/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.TLManager;
import de.governikus.csl.uom.core.AlgorithmServiceFacade;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.crl.CRLRequester;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequester;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.tslextension.ValMethodCRL;
import de.governikus.tslextension.ValMethodOCSP;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLExtensionBasedRevocationValueService
extends RevocationValueBuilder
implements RevocationValueService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLExtensionBasedRevocationValueService.class);
    private TLManager tlManager;
    private OCSPRequester ocspRequester;
    private CRLRequester crlRequester;
    private AlgorithmServiceFacade algorithmService = new AlgorithmServiceFacade();

    public TLExtensionBasedRevocationValueService(TLManager tlManager, OCSPRequester ocspRequester, CRLRequester crlRequester) {
        this.tlManager = tlManager;
        this.ocspRequester = ocspRequester;
        this.crlRequester = crlRequester;
    }

    @Override
    public RevocationValue getRevocationValue(BaseCertificateSignature<?> so, SignatureValidationContext context, boolean onlyOCSP) {
        Object cert = so.getCert();
        ServiceInformation issuerServiceInformation = this.tlManager.getIssuerServiceInformation(cert);
        if (issuerServiceInformation != null) {
            RevocationValue res;
            ValMethodCRL valMethodCRL = issuerServiceInformation.getValMethodCRL();
            if (!onlyOCSP && valMethodCRL != null && (res = this.getCRL(valMethodCRL, (X509CertificateBaseFacade<?>)cert)) != null) {
                return res;
            }
            ValMethodOCSP valMethodOCSP = issuerServiceInformation.getValMethodOCSP();
            if (valMethodOCSP != null) {
                return this.getOCSP(valMethodOCSP, (X509CertificateBaseFacade<?>)cert, so.getSigningCertificate());
            }
        } else {
            LOGGER.debug("No issuer service information found in TL.");
        }
        return null;
    }

    private RevocationValue getOCSP(ValMethodOCSP valMethodOCSP, X509CertificateBaseFacade<?> cert, X509CertificateImpl issuerCert) {
        if (issuerCert == null) {
            LOGGER.debug("Can't find issuer certificate. OCSP request can't be build");
            return null;
        }
        String url = valMethodOCSP.getUrl();
        if (url == null) {
            LOGGER.debug("Required OCSP URL missing in ValMethodOCSP");
            return null;
        }
        try {
            TimedRevocationRequestResponse resp = this.ocspRequester.getOCSPResponse(cert, (X509Certificate)issuerCert, url);
            if (resp != null && this.matches((OCSPResp)resp.getResponse(), cert, (AlgorithmManager)this.algorithmService)) {
                RevocationValue result = this.buildOCSPResponse((TimedRevocationRequestResponse<OCSPResp>)resp);
                result.setSource(InformationSource.ONLINE);
                result.setUrl(valMethodOCSP.getUrl());
                return result;
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Can't get OCSP from url {}", (Object)url, (Object)e);
            } else {
                LOGGER.warn("Can't get OCSP from url {}: {}", (Object)url, (Object)e.getMessage());
            }
            return this.ocspRequester.revocationValueFromException(e);
        }
        return null;
    }

    private RevocationValue getCRL(ValMethodCRL valMethodCRL, X509CertificateBaseFacade<?> cert) {
        TimedRevocationRequestResponse<X509CRL> crl = null;
        try {
            crl = this.crlRequester.getCRL(valMethodCRL);
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Can't get CRL from URL {}", (Object)valMethodCRL.getUrl(), (Object)e);
            }
            LOGGER.warn("Can't get CRL from URL {}: {}", (Object)valMethodCRL.getUrl(), (Object)e.getMessage());
        }
        if (crl != null) {
            RevocationValue result = this.buildCRLResponse(crl, cert);
            result.setSource(InformationSource.ONLINE);
            result.setUrl(valMethodCRL.getUrl());
            return result;
        }
        return null;
    }
}

