/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.tslextension.ValMethodOCSP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValueCacheTimeCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationValueCacheTimeCalculator.class);

    public long chooseMaxCacheTime(BaseCertificateSignature<?> so, SignatureValidationContext context) {
        long cacheTime;
        Object cert = so.getCert();
        String subject = cert.getSubjectX500Principal().toString();
        int posInChain = context.getCertChainValidationDepth().getCurrentPositionInCertChain();
        LOGGER.trace("Determining max cache time for [{}]", (Object)subject);
        if (so != null && (cacheTime = this.getMaxCacheTimeFromTLExtension(so, posInChain, subject)) >= 0L) {
            return cacheTime;
        }
        return this.getMaxCacheTimeFromPolicy((ValidatePolicy)context.getPolicy(), posInChain);
    }

    private long getMaxCacheTimeFromTLExtension(BaseCertificateSignature<?> so, int posInChain, String subject) {
        ExtendedTLInformation tslInformation = so.getTslInformation();
        if (posInChain <= 1) {
            return this.getMaxCacheTimeFromTLExtension(so.getIssuerServiceInformation(), subject, tslInformation);
        }
        return this.getMaxCacheTimeFromTLExtension(so.getServiceInformation(), subject, tslInformation);
    }

    private long getMaxCacheTimeFromTLExtension(ServiceInformation serviceInformation, String subject, ExtendedTLInformation tslInformation) {
        if (serviceInformation == null) {
            return -1L;
        }
        String tlName = this.getTlName(tslInformation);
        ValMethodOCSP valMethodOCSP = serviceInformation.getValMethodOCSP();
        if (valMethodOCSP == null) {
            LOGGER.trace("Falling back to values from policy. Found no cache time in TL extension [{}] for [{}]", (Object)tlName, (Object)subject);
            return -1L;
        }
        Integer cacheTimeout = valMethodOCSP.getCacheTimeout();
        LOGGER.trace("Got max cache time [{}] sec from TL extension [{}] for [{}]", new Object[]{cacheTimeout, tlName, subject});
        return (long)cacheTimeout.intValue() * 1000L;
    }

    private String getTlName(ExtendedTLInformation tslInformation) {
        if (tslInformation == null) {
            return "UNKNOWN";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tslInformation.getTslType());
        TLInfo tslExtensionInfo = tslInformation.getTslExtensionInfo();
        if (tslExtensionInfo != null) {
            sb.append("_TL_");
            String countryCode = tslExtensionInfo.getCountryCode();
            sb.append(countryCode != null ? countryCode : "??");
            sb.append("-");
            sb.append(tslExtensionInfo.getId());
        }
        return sb.toString();
    }

    private long getMaxCacheTimeFromPolicy(ValidatePolicy policy, int posInChain) {
        Long maxDuration = -1L;
        maxDuration = posInChain <= 1 ? policy.getMaxOCSPCacheDurationEE() : policy.getMaxOCSPCacheDurationCA();
        return maxDuration;
    }
}

