/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.RevocationStatus;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.service.RevocationValueCacheTimeCalculator;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Date;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValueCache
implements RevocationValueService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationValueCache.class);
    private Cache<CertificateBase, RevocationValue> cache;
    private RevocationValueService service;
    private long maxCacheTime = 300000L;
    private RevocationValueCacheTimeCalculator cacheTimeCalculator;

    public RevocationValueCache(RevocationValueService service, Cache<CertificateBase, RevocationValue> cache) {
        this.cache = cache;
        if (cache == null) {
            LOGGER.warn("No CachingProviders have been configured. Caching is disabled");
        }
        this.service = service;
        this.cacheTimeCalculator = new RevocationValueCacheTimeCalculator();
    }

    @Override
    public RevocationValue getRevocationValue(BaseCertificateSignature<?> so, SignatureValidationContext context, boolean onlyOCSP) {
        Object c = so.getCert();
        BigInteger serialNumber = c.getSerialNumber();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Try to find revocation value in cache for certificate {} with serial {}", (Object)c.getSubjectX500Principal(), (Object)serialNumber);
        }
        if (LOGGER.isTraceEnabled()) {
            try {
                byte[] encoded = c.getEncoded();
                String base64 = Base64.getEncoder().encodeToString(encoded);
                LOGGER.trace("{}={}", (Object)serialNumber, (Object)base64);
            }
            catch (Exception e) {
                LOGGER.error("Cannot log certificate {}: {}", (Object)serialNumber, (Object)e.getMessage());
            }
        }
        RevocationValue rv = null;
        if (this.cache != null && (rv = (RevocationValue)this.cache.get(c)) != null) {
            LOGGER.debug("Got revocation value from cache!");
            long maxCacheTime = this.cacheTimeCalculator.chooseMaxCacheTime(so, context);
            if (maxCacheTime < 0L) {
                maxCacheTime = this.maxCacheTime;
                LOGGER.debug("Got no cache timeout from extension or policy, using default of [{}] ms!", (Object)maxCacheTime);
            }
            long now = System.currentTimeMillis();
            long age = now - maxCacheTime - 1L;
            Date creationDate = rv.getCreationDate();
            if (creationDate != null) {
                LOGGER.debug("Creation date of revocation value from cache is [{}]!", (Object)creationDate);
                age = rv.getCreationDate().getTime();
            } else {
                LOGGER.debug("Retrieved revocation value without creation date from cache, requesting again!");
            }
            if (!onlyOCSP || rv.getOcspValue() != null) {
                long relativeAgeMs = now - age;
                if (relativeAgeMs <= maxCacheTime) {
                    LOGGER.debug("Found entry in cache for [{}] with age [{}] < cacheTimeout [{}]", new Object[]{c.getSubjectX500Principal(), relativeAgeMs, maxCacheTime});
                    RevocationValue copy = new RevocationValue(rv);
                    copy.setSource(InformationSource.CACHE);
                    return copy;
                }
                LOGGER.debug("Revocation value from cache is too old!");
            } else {
                LOGGER.debug("Only ocsp values are allowed but item in cache is crl!");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("revocation value not found cache for certificate {} with serial {}", (Object)c.getSubjectX500Principal(), (Object)c.getSerialNumber());
        }
        rv = this.service.getRevocationValue(so, context, onlyOCSP);
        if (this.cache != null && rv != null && rv.getStatus() != RevocationStatus.UNKNOWN) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("adding revocation value to cache for certificate {} with serial {}", (Object)c.getSubjectX500Principal(), (Object)c.getSerialNumber());
            }
            this.cache.put(c, (Object)rv);
        }
        return rv;
    }

    public long getMaxCacheTime() {
        return this.maxCacheTime;
    }

    public void setMaxCacheTime(long maxCacheTime) {
        this.maxCacheTime = maxCacheTime;
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }
}

