/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListRevocationValueService
extends RevocationValueBuilder
implements RevocationValueService {
    private List<SignatureValidationDataAttachment<OCSPResp>> ocsps;
    private List<SignatureValidationDataAttachment<CRL>> crls;
    private AlgorithmManager algorithmManager;
    private InformationSource source;
    private static final Logger LOGGER = LoggerFactory.getLogger(ListRevocationValueService.class);

    public ListRevocationValueService(List<SignatureValidationDataAttachment<OCSPResp>> ocsp, List<SignatureValidationDataAttachment<CRL>> crlValues, AlgorithmManager algorithmManager, InformationSource source) {
        this.crls = crlValues;
        this.ocsps = ocsp;
        this.algorithmManager = algorithmManager;
        this.source = source;
    }

    @Override
    public RevocationValue getRevocationValue(BaseCertificateSignature<?> so, SignatureValidationContext context, boolean onlyOCSP) {
        Object userCert = so.getCert();
        X509CertificateImpl signingCertificate = so.getSigningCertificate();
        RevocationValue result = null;
        if (this.ocsps != null && signingCertificate != null) {
            X509Certificate issuerCert = (X509Certificate)signingCertificate.getWrappedCertificate();
            result = this.getOfflineOCSPs((X509CertificateBaseFacade<?>)userCert, issuerCert);
        }
        if (result == null && this.crls != null && !onlyOCSP) {
            result = this.getOfflineCRL((X509CertificateBaseFacade<?>)userCert);
        }
        if (result != null) {
            result.setSource(this.source);
        }
        return result;
    }

    private RevocationValue getOfflineCRL(X509CertificateBaseFacade<?> userCert) {
        X500Principal issuerP = userCert.getIssuerX500Principal();
        for (SignatureValidationDataAttachment<CRL> crl : this.crls) {
            X509CRL xCrl = (X509CRL)crl.getValue();
            X500Principal crlIssuerP = xCrl.getIssuerX500Principal();
            if (!issuerP.equals(crlIssuerP)) continue;
            return this.buildCRLResponse(xCrl, userCert, crl.getPOEs());
        }
        return null;
    }

    private RevocationValue getOfflineOCSPs(X509CertificateBaseFacade<?> userCert, X509Certificate issuerCert) {
        String lastOID = null;
        MessageDigest md = null;
        for (SignatureValidationDataAttachment<OCSPResp> resp : this.ocsps) {
            SingleResp[] srs;
            BasicOCSPResp rv;
            OCSPResp response;
            block10: {
                response = (OCSPResp)resp.getValue();
                rv = null;
                try {
                    Object responseObject = response.getResponseObject();
                    if (responseObject == null) break block10;
                    rv = (BasicOCSPResp)responseObject;
                }
                catch (OCSPException e1) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Could not process oscp response.", (Throwable)e1);
                        continue;
                    }
                    LOGGER.warn("Could not process oscp response: {}", (Object)e1.getMessage());
                    continue;
                }
            }
            if (rv == null) {
                LOGGER.debug("OCSP does not contain a response object");
                continue;
            }
            for (SingleResp sr : srs = rv.getResponses()) {
                byte[] issuerNameHash;
                byte[] searchIssuerNameHash;
                CertificateID certID = sr.getCertID();
                if (!certID.getSerialNumber().equals(userCert.getSerialNumber())) continue;
                String oid = certID.getHashAlgOID().getId();
                if (lastOID == null || !lastOID.equals(oid)) {
                    DigestAlgorithm digestAlgorithm = this.algorithmManager.getDigestAlgorithmByOID(oid);
                    try {
                        md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
                    }
                    catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Invalid digest algorithm.", (Throwable)e);
                            continue;
                        }
                        LOGGER.warn("Invalid digest algorithm: {}", (Object)e.getMessage());
                        continue;
                    }
                    lastOID = oid;
                }
                if (!Arrays.equals(searchIssuerNameHash = md.digest(userCert.getIssuerX500Principal().getEncoded()), issuerNameHash = certID.getIssuerNameHash())) continue;
                return this.buildOCSPResponse(response, resp.getPOEs());
            }
        }
        return null;
    }

    @Generated
    public List<SignatureValidationDataAttachment<OCSPResp>> getOcsps() {
        return this.ocsps;
    }

    @Generated
    public List<SignatureValidationDataAttachment<CRL>> getCrls() {
        return this.crls;
    }

    @Generated
    public AlgorithmManager getAlgorithmManager() {
        return this.algorithmManager;
    }

    @Generated
    public InformationSource getSource() {
        return this.source;
    }
}

