/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequester;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastURLRevocationService
extends RevocationValueBuilder
implements RevocationValueService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LastURLRevocationService.class);
    private OCSPRequester ocspRequester;

    @Override
    public RevocationValue getRevocationValue(BaseCertificateSignature<?> so, SignatureValidationContext context, boolean onlyOCSP) {
        String lastOCSPURL = context.getLastOCSPURL();
        if (lastOCSPURL == null) {
            return null;
        }
        Object userCert = so.getCert();
        X509CertificateImpl signingCertificate = so.getSigningCertificate();
        if (signingCertificate == null) {
            LOGGER.debug("Issuer certificate not found, can't create OCSP request");
            return null;
        }
        X509Certificate issuerCert = (X509Certificate)signingCertificate.getWrappedCertificate();
        try {
            TimedRevocationRequestResponse resp = this.ocspRequester.getOCSPResponse(userCert, issuerCert, lastOCSPURL);
            if (resp != null) {
                RevocationValue ocspResponse = this.buildOCSPResponse((TimedRevocationRequestResponse<OCSPResp>)resp);
                ocspResponse.setSource(InformationSource.ONLINE);
                ocspResponse.setUrl(lastOCSPURL);
                return ocspResponse;
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Can't get OCSP from url {}", (Object)lastOCSPURL, (Object)e);
            } else {
                LOGGER.warn("Can't get OCSP from url {}: {}", (Object)lastOCSPURL, (Object)e.getMessage());
            }
            return this.ocspRequester.revocationValueFromException(e);
        }
        return null;
    }

    public LastURLRevocationService(OCSPRequester ocspRequester) {
        this.ocspRequester = ocspRequester;
    }
}

