/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.crl.CRLRequester;
import de.governikus.csl.validation.revocation.crl.HttpPreferringGeneralNamesComparator;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequestBuilderException;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequester;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertBasedRevocationValueService
extends RevocationValueBuilder
implements RevocationValueService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertBasedRevocationValueService.class);
    private HttpPreferringGeneralNamesComparator generalNamesComparator = new HttpPreferringGeneralNamesComparator();
    private OCSPRequester ocspRequester;
    private CRLRequester crlRequester;

    public CertBasedRevocationValueService(OCSPRequester ocspRequester, CRLRequester crlRequester) {
        this.ocspRequester = ocspRequester;
        this.crlRequester = crlRequester;
    }

    @Override
    public RevocationValue getRevocationValue(BaseCertificateSignature<?> so, SignatureValidationContext context, boolean onlyOCSP) {
        Object userCert = so.getCert();
        RevocationValue revValOcsp = null;
        byte[] value = userCert.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (value != null && (revValOcsp = this.getFromAuthorityInformationAccess((X509CertificateBaseFacade<?>)userCert, so.getSigningCertificate(), value)) != null && revValOcsp.hasNoValidationMessages()) {
            return revValOcsp;
        }
        RevocationValue revValCRL = null;
        value = userCert.getExtensionValue("2.5.29.31");
        if (value != null && !onlyOCSP) {
            revValCRL = this.getFromCRLDistributionPoint((X509CertificateBaseFacade<?>)userCert, value);
        }
        if (revValCRL != null) {
            return revValCRL;
        }
        if (revValOcsp != null) {
            return revValOcsp;
        }
        return null;
    }

    private RevocationValue getFromCRLDistributionPoint(X509CertificateBaseFacade<?> userCert, byte[] value) {
        try {
            OCTETSTRING o = new OCTETSTRING(Run.create((Source)new BSource(value)));
            value = o.getOctets();
        }
        catch (ParseException e) {
            LOGGER.debug("CRLDistPoint is not encoded in octet string");
        }
        CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)value);
        RevocationValue result = this.processCRLDistPoint(userCert, distPoint);
        if (result != null) {
            return result;
        }
        return null;
    }

    private RevocationValue getFromAuthorityInformationAccess(X509CertificateBaseFacade<?> userCert, X509CertificateImpl issuerCert, byte[] value) {
        try {
            OCTETSTRING o = new OCTETSTRING(Run.create((Source)new BSource(value)));
            value = o.getOctets();
        }
        catch (ParseException e) {
            LOGGER.debug("CRLDistPoint is not encoded in octet string");
        }
        try {
            AuthorityInformationAccess ic = AuthorityInformationAccess.getInstance((Object)value);
            AccessDescription[] accessDescriptions = ic.getAccessDescriptions();
            if (accessDescriptions != null) {
                ArrayList valMsgCodes = new ArrayList();
                for (AccessDescription ad : accessDescriptions) {
                    RevocationValue res = this.getFromAccessDescription(ad, userCert, issuerCert);
                    if (res == null) continue;
                    List valMsgCodesTmp = res.getValidationMessageCodes();
                    if (res.hasNoValidationMessages()) {
                        return res;
                    }
                    valMsgCodes.addAll(valMsgCodesTmp);
                }
                if (!valMsgCodes.isEmpty()) {
                    RevocationValue defaultRv = new RevocationValue();
                    defaultRv.setValidationMessageCodes(valMsgCodes);
                    return defaultRv;
                }
                return null;
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Can't parse AuthorityInfoAccess", (Throwable)e);
            } else {
                LOGGER.error("Can't parse AuthorityInfoAccess: {}", (Object)e.getMessage());
            }
            return this.ocspRequester.revocationValueFromException(e);
        }
        return null;
    }

    private RevocationValue getFromAccessDescription(AccessDescription ad, X509CertificateBaseFacade<?> userCert, X509CertificateImpl issuerCert) throws IOException, OCSPRequestBuilderException {
        ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
        String oid = accessMethod.getId();
        GeneralName accessLocation = ad.getAccessLocation();
        String url = accessLocation.getName().toString();
        if (oid.equals("1.3.6.1.5.5.7.48.1")) {
            TimedRevocationRequestResponse resp;
            if (issuerCert == null) {
                LOGGER.debug("Issuer certificate not found, can't create OCSP request");
                RevocationValue revocationValue = new RevocationValue();
                revocationValue.addValidationMessage("revocation_values_not_found_missing_issuer", new Object[]{url});
                return revocationValue;
            }
            try {
                resp = this.ocspRequester.getOCSPResponse(userCert, (X509Certificate)issuerCert.getWrappedCertificate(), url);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Can't get OCSP from url {}", (Object)url, (Object)e);
                } else {
                    LOGGER.warn("Can't get OCSP from url {}: {}", (Object)url, (Object)e.getMessage());
                }
                return this.ocspRequester.revocationValueFromException(e);
            }
            if (resp != null) {
                RevocationValue ocspResponse = this.buildOCSPResponse((TimedRevocationRequestResponse<OCSPResp>)resp);
                ocspResponse.setSource(InformationSource.ONLINE);
                ocspResponse.setUrl(url);
                return ocspResponse;
            }
        }
        return null;
    }

    private RevocationValue processCRLDistPoint(X509CertificateBaseFacade<?> userCert, CRLDistPoint distPoint) {
        RevocationValue result = null;
        for (DistributionPoint dp : distPoint.getDistributionPoints()) {
            result = this.processDistributionPoint(userCert, dp);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private RevocationValue processDistributionPoint(X509CertificateBaseFacade<?> userCert, DistributionPoint dp) {
        DistributionPointName distributionPoint = dp.getDistributionPoint();
        GeneralNames crlIssuer = dp.getCRLIssuer();
        if (distributionPoint != null) {
            ASN1Encodable distributionPointName = distributionPoint.getName();
            if (distributionPoint.getType() == 0) {
                GeneralNames names = (GeneralNames)distributionPointName;
                GeneralName[] namesArray = names.getNames();
                Arrays.sort(namesArray, this.generalNamesComparator);
                for (GeneralName name : namesArray) {
                    RevocationValue res = this.getCRLFromGeneralName(name, userCert);
                    if (res == null) continue;
                    return res;
                }
            } else if (distributionPoint.getType() == 1) {
                LOGGER.debug("Distribution point: {}", (Object)distributionPointName);
            }
        } else if (crlIssuer != null) {
            LOGGER.debug("CRLIssuer found in distribution point");
        }
        return null;
    }

    private RevocationValue getCRLFromGeneralName(GeneralName name, X509CertificateBaseFacade<?> userCert) {
        int tagNo = name.getTagNo();
        if (tagNo == 6) {
            DERIA5String name2 = (DERIA5String)name.getName();
            String url = name2.getString();
            TimedRevocationRequestResponse<X509CRL> crl = null;
            try {
                crl = this.crlRequester.getCRL(url);
            }
            catch (IOException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Can't get CRL from url {}", (Object)url, (Object)e);
                }
                LOGGER.warn("Can't get CRL from url {}: {}", (Object)url, (Object)e.getMessage());
            }
            if (crl != null) {
                RevocationValue buildCRLResponse = this.buildCRLResponse(crl, userCert);
                buildCRLResponse.setSource(InformationSource.ONLINE);
                buildCRLResponse.setUrl(url);
                return buildCRLResponse;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unsupported general name with type {}: {}", (Object)tagNo, (Object)name);
        }
        return null;
    }
}

