/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.service;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.service.ListRevocationValueService;
import de.governikus.csl.validation.revocation.service.RevocationValueService;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.security.cert.CRL;
import java.util.List;
import lombok.Generated;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class AttachedRevocationValueService
extends RevocationValueBuilder
implements RevocationValueService {
    private boolean defaultFirst;
    private RevocationValueService defaultService;
    private RevocationValueService localService;

    public AttachedRevocationValueService(List<SignatureValidationDataAttachment<OCSPResp>> ocsp, List<SignatureValidationDataAttachment<CRL>> attachedCRLs, RevocationValueService defaultService, boolean defaultFirst, AlgorithmManager algorithmManager, InformationSource source) {
        this(new ListRevocationValueService(ocsp, attachedCRLs, algorithmManager, source), defaultService, defaultFirst, algorithmManager, source);
    }

    public AttachedRevocationValueService(RevocationValueService localService, RevocationValueService defaultService, boolean defaultFirst, AlgorithmManager algorithmManager) {
        this(localService, defaultService, defaultFirst, algorithmManager, InformationSource.SIGNATURE);
    }

    public AttachedRevocationValueService(RevocationValueService localService, RevocationValueService defaultService, boolean defaultFirst, AlgorithmManager algorithmManager, InformationSource source) {
        this.localService = localService;
        this.defaultService = defaultService;
        this.defaultFirst = defaultFirst;
    }

    @Override
    public RevocationValue getRevocationValue(BaseCertificateSignature<?> so, SignatureValidationContext context, boolean onlyOCSP) {
        RevocationValue result = null;
        if (this.defaultFirst) {
            result = this.defaultService.getRevocationValue(so, context, onlyOCSP);
            if (result == null) {
                result = this.localService.getRevocationValue(so, context, onlyOCSP);
            }
        } else {
            result = this.localService.getRevocationValue(so, context, onlyOCSP);
            if (result == null) {
                result = this.defaultService.getRevocationValue(so, context, onlyOCSP);
            }
        }
        return result;
    }

    @Generated
    public boolean isDefaultFirst() {
        return this.defaultFirst;
    }

    @Generated
    public RevocationValueService getDefaultService() {
        return this.defaultService;
    }

    @Generated
    public RevocationValueService getLocalService() {
        return this.localService;
    }
}

