/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.ocsp;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.revocation.AbstractRevocationValuePlugin;
import de.governikus.csl.validation.revocation.ReferencedCertificateHashCheck;
import de.governikus.csl.validation.revocation.RevocationFreshnessCheck;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueDatesCheck;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import de.governikus.csl.validation.revocation.criteria.RevocationValueTrustCheck;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.ocsp.OCSPResp;

@PluginType(id=Plugin.PluginID.VALIDATE_OCSP, type=ValidatePlugin.class)
public class OCSPPlugin
extends AbstractRevocationValuePlugin {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevocationValueData parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        Document signatureData = doc.getSignature();
        OCSPResp resp = null;
        try (InputStream stream = signatureData.getInputStream();){
            resp = new OCSPResp(stream);
            RevocationValueData rvd = this.parseDocument(resp);
            tempDataManager.add((Closeable)stream);
            RevocationValueData revocationValueData = rvd;
            return revocationValueData;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            throw new ValidatePluginException(this, "Can't parse document", e);
        }
    }

    public RevocationValueData parseDocument(OCSPResp doc) throws ValidatePluginException {
        RevocationValueBuilder builder = new RevocationValueBuilder();
        return this.parseDocument(builder.buildOCSPResponse(doc, null), (CertStore)this.configuration.getCertStore());
    }

    public static List<ValidationCriterion<? super RevocationValueData, ? super RevocationValueValidationResult, ? super RevocationValueValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super RevocationValueData, ? super RevocationValueValidationResult, ? super RevocationValueValidationContext>> result = new ArrayList<ValidationCriterion<? super RevocationValueData, ? super RevocationValueValidationResult, ? super RevocationValueValidationContext>>();
        result.add(new RevocationFreshnessCheck());
        result.add(new ReferencedCertificateHashCheck());
        result.add(new RevocationValueDatesCheck());
        result.add(new RevocationValueTrustCheck());
        return result;
    }
}

