/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.crl;

import de.governikus.csl.validation.revocation.crl.CRLRequester;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import de.governikus.tslextension.ValMethodCRL;
import java.security.cert.X509CRL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCRLRequester
implements CRLRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartCRLRequester.class);
    private Map<String, Future<TimedRevocationRequestResponse<X509CRL>>> currentRequests = new ConcurrentHashMap<String, Future<TimedRevocationRequestResponse<X509CRL>>>();
    private CRLRequester service;

    public SmartCRLRequester(CRLRequester service) {
        this.service = service;
    }

    @Override
    public TimedRevocationRequestResponse<X509CRL> getCRL(ValMethodCRL crlMethod) {
        return this.getCRL(crlMethod.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimedRevocationRequestResponse<X509CRL> getCRL(String url) {
        TimedRevocationRequestResponse<X509CRL> resp = null;
        Future<TimedRevocationRequestResponse<X509CRL>> future = this.currentRequests.get(url);
        if (future != null) {
            LOGGER.debug("Parallel ocsp request detected");
            try {
                resp = future.get();
                if (resp != null) {
                    LOGGER.debug("Using result from parallel request. That saved me {} ms", (Object)resp.getRequestDuration());
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Exception during waiting of crl response", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOGGER.info("Exception during waiting of crl response", (Throwable)e);
            }
        } else {
            CompletableFuture<TimedRevocationRequestResponse<X509CRL>> f = new CompletableFuture<TimedRevocationRequestResponse<X509CRL>>();
            this.currentRequests.put(url, f);
            try {
                resp = this.service.getCRL(url);
                f.complete(resp);
            }
            catch (Exception e) {
                f.completeExceptionally(e);
            }
            finally {
                this.currentRequests.remove(url);
                f.complete(resp);
            }
        }
        return resp;
    }
}

