/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.crl;

import de.governikus.csl.transport.Downloader;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.utils.LdapURL;
import de.governikus.csl.validation.revocation.crl.CRLRequester;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import de.governikus.tslextension.ValMethodCRL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.cert.X509CRL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.x509.util.StreamParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineCRLRequester
extends Downloader
implements CRLRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineCRLRequester.class);

    public OnlineCRLRequester(HttpClient transportFactory, boolean sendNoCacheHeader, Map<String, String> ldapEnv) {
        super(transportFactory, sendNoCacheHeader, ldapEnv);
    }

    @Override
    public TimedRevocationRequestResponse<X509CRL> getCRL(ValMethodCRL crlMethod) {
        return this.getCRL(crlMethod.getUrl());
    }

    private TimedRevocationRequestResponse<X509CRL> getFromLDAP(String ldapURL) throws StreamParsingException, NamingException, URISyntaxException {
        LOGGER.info("Loading CRL from URL: {}", (Object)ldapURL);
        long time = System.currentTimeMillis();
        LdapURL url = new LdapURL(ldapURL);
        if (url.getHost() == null) {
            LOGGER.info("URL does not contain a host. Skipping downloading of CRL");
            return null;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.provider.url", url.getProviderURL());
        String[] attributes = new String[]{};
        List attributes2 = url.getAttributes();
        if (attributes2 != null) {
            attributes = attributes2.toArray(attributes);
        }
        byte[] val = this.sendLDAPRequestCRL(ldapURL, env, attributes);
        long delta = System.currentTimeMillis() - time;
        if (val == null || val.length == 0) {
            return null;
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        X509CRLParser parser = new X509CRLParser();
        parser.engineInit((InputStream)inStream);
        X509CRL crl = (X509CRL)parser.engineRead();
        if (crl == null) {
            return null;
        }
        return new TimedRevocationRequestResponse((Object)crl, delta);
    }

    private TimedRevocationRequestResponse<X509CRL> getFromHTTP(String surl) throws IOException, StreamParsingException {
        LOGGER.info("Loading CRL from URL: {}", (Object)surl);
        long time = System.currentTimeMillis();
        byte[] binaryFile = this.getBinaryFile(surl);
        if (binaryFile == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binaryFile);){
            X509CRLParser parser = new X509CRLParser();
            parser.engineInit((InputStream)is);
            X509CRL crl = (X509CRL)parser.engineRead();
            if (crl == null) {
                TimedRevocationRequestResponse<X509CRL> timedRevocationRequestResponse = null;
                return timedRevocationRequestResponse;
            }
            long delta = System.currentTimeMillis() - time;
            TimedRevocationRequestResponse timedRevocationRequestResponse = new TimedRevocationRequestResponse((Object)crl, delta);
            return timedRevocationRequestResponse;
        }
    }

    @Override
    public TimedRevocationRequestResponse<X509CRL> getCRL(String url) {
        TimedRevocationRequestResponse<X509CRL> crl;
        block4: {
            crl = null;
            try {
                if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://")) {
                    crl = this.getFromHTTP(url);
                    break block4;
                }
                if (url.startsWith("ldap://")) {
                    crl = this.getFromLDAP(url);
                    break block4;
                }
                return null;
            }
            catch (IOException | URISyntaxException | NoSuchElementException | NamingException | StreamParsingException e) {
                LOGGER.info("Exception occured during loading of crl from URL \"{}\"", (Object)url);
                LOGGER.debug("Exception:", e);
            }
        }
        return crl;
    }
}

