/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.crl;

import de.governikus.csl.validation.circuitbreaker.CircuitBreaker;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerManager;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerOptions;
import de.governikus.csl.validation.revocation.crl.CRLRequester;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import de.governikus.tslextension.ValMethodCRL;
import java.io.IOException;
import java.security.cert.X509CRL;

public class FailFastCRLRequester
implements CRLRequester {
    private CRLRequester delegate;
    private CircuitBreakerManager manager;

    public FailFastCRLRequester(CRLRequester delegate, CircuitBreakerOptions options) {
        this.delegate = delegate;
        this.manager = new CircuitBreakerManager(options);
    }

    public FailFastCRLRequester(CRLRequester delegate, CircuitBreakerManager manager) {
        this.delegate = delegate;
        this.manager = manager;
    }

    @Override
    public TimedRevocationRequestResponse<X509CRL> getCRL(ValMethodCRL crlMethod) throws IOException {
        return this.getCRL(crlMethod.getUrl(), crlMethod, this.delegate::getCRL);
    }

    @Override
    public TimedRevocationRequestResponse<X509CRL> getCRL(String url) throws IOException {
        return this.getCRL(url, url, this.delegate::getCRL);
    }

    private <I> TimedRevocationRequestResponse<X509CRL> getCRL(String url, I input, CRLGetterFunction<I> f) throws IOException {
        CircuitBreaker circuitBreaker = this.manager.get(url);
        circuitBreaker.check();
        try {
            TimedRevocationRequestResponse<X509CRL> response = f.apply(input);
            circuitBreaker.reportSuccess();
            return response;
        }
        catch (IOException e) {
            circuitBreaker.reportFailure();
            throw e;
        }
    }

    @FunctionalInterface
    private static interface CRLGetterFunction<I> {
        public TimedRevocationRequestResponse<X509CRL> apply(I var1) throws IOException;
    }
}

