/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.crl;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validation.IssuerCertificateResolver;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.revocation.AbstractRevocationValuePlugin;
import de.governikus.csl.validation.revocation.ReferencedCertificateHashCheck;
import de.governikus.csl.validation.revocation.RevocationFreshnessCheck;
import de.governikus.csl.validation.revocation.RevocationValueBuilder;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueDatesCheck;
import de.governikus.csl.validation.revocation.RevocationValueIssuerCheck;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import de.governikus.csl.validation.revocation.criteria.RevocationValueTrustCheck;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.x509.util.StreamParsingException;

@PluginType(id=Plugin.PluginID.VALIDATE_CRL, type=ValidatePlugin.class)
public class CRLPlugin
extends AbstractRevocationValuePlugin {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevocationValueData parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        Document signature = doc.getSignature();
        try (InputStream is = signature.getInputStream();){
            X509CRLParser parser = new X509CRLParser();
            parser.engineInit(is);
            X509CRL crl = (X509CRL)parser.engineRead();
            if (crl == null) {
                RevocationValueData revocationValueData = null;
                return revocationValueData;
            }
            RevocationValueData result = this.parseDocument(crl);
            if (doc.getSignature().getName() != null) {
                result.setName(doc.getSignature().getName());
            }
            RevocationValueData revocationValueData = result;
            return revocationValueData;
        }
        catch (IOException | StreamParsingException e) {
            throw new ValidatePluginException(this, "Can't parse document", e);
        }
    }

    public RevocationValueData parseDocument(X509CRL doc) throws ValidatePluginException {
        RevocationValueBuilder builder = new RevocationValueBuilder();
        RevocationValue revoValue = builder.buildCRLResponse(doc, null, null);
        return this.parseDocument(revoValue, (CertStore)this.configuration.getCertStore());
    }

    @Override
    public IssuerCertificateResolver<RevocationValueData> getCertificateResolver() {
        return new IssuerCertificateResolver<RevocationValueData>(){

            @Override
            public CertStoreResponse getIssuerCertificates(RevocationValueData source, CertStore store) {
                if (store == null) {
                    return null;
                }
                RevocationValue rv = source.getValue();
                X509CRL crl = rv.getCrlValue();
                return store.getSigningCertificates(crl);
            }
        };
    }

    public static List<ValidationCriterion<? super RevocationValueData, ? super RevocationValueValidationResult, ? super RevocationValueValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super RevocationValueData, ? super RevocationValueValidationResult, ? super RevocationValueValidationContext>> result = new ArrayList<ValidationCriterion<? super RevocationValueData, ? super RevocationValueValidationResult, ? super RevocationValueValidationContext>>();
        result.add(new RevocationFreshnessCheck());
        result.add(new ReferencedCertificateHashCheck());
        result.add(new RevocationValueDatesCheck());
        result.add(new RevocationValueIssuerCheck());
        result.add(new RevocationValueTrustCheck());
        return result;
    }
}

