/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.attributecert.AttributeCertificateSignature;
import de.governikus.csl.validation.x509.CertificateProcessor;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Date;

public class RevocationValueTrustCheckCertProcessor
implements CertificateProcessor<ValidationResult> {
    private Date retentionIntervalStart;
    private Date revocationValueIssuanceTime;
    private Date revocationDate;

    public RevocationValueTrustCheckCertProcessor(Date revocationDate, Date retentionIntervalStart, Date revocationValueIssuanceTime) {
        this.revocationDate = revocationDate;
        this.retentionIntervalStart = retentionIntervalStart;
        this.revocationValueIssuanceTime = revocationValueIssuanceTime;
    }

    @Override
    public ValidationResult process(AttributeCertificateSignature attributeCert) {
        X509AttributeCertificateImpl cert = (X509AttributeCertificateImpl)attributeCert.getCert();
        return this.validate(cert.getNotBefore(), cert.getNotAfter(), this.retentionIntervalStart, this.revocationValueIssuanceTime);
    }

    @Override
    public ValidationResult process(X509Data cert) {
        ServiceInformation serviceInformation;
        Date retentionInterval = this.retentionIntervalStart;
        if (retentionInterval == null && (serviceInformation = cert.getServiceInformation()) != null) {
            retentionInterval = serviceInformation.getExpiredCertsRevocationInfo();
        }
        X509CertificateImpl x509 = (X509CertificateImpl)cert.getCert();
        return this.validate(x509.getNotBefore(), x509.getNotAfter(), retentionInterval, this.revocationValueIssuanceTime);
    }

    private ValidationResult validate(Date notBefore, Date notAfter, Date startOfRetentionInterval, Date issuanceTime) {
        Date minNotAfter = startOfRetentionInterval;
        if (minNotAfter == null) {
            minNotAfter = issuanceTime;
        }
        if (notAfter.before(minNotAfter)) {
            if (this.revocationDate != null) {
                return SVPFactory.createResultOk();
            }
            if (startOfRetentionInterval != null) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_value_trust_invalid"});
            }
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_value_trust_invalid_no_retention"});
        }
        if (notAfter.before(issuanceTime)) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"revocation_value_trust_valid_because_retention"});
        }
        return SVPFactory.createResultOk();
    }

    public Date getRetentionIntervalStart() {
        return this.retentionIntervalStart;
    }

    public Date getRevocationValueIssuanceTime() {
        return this.revocationValueIssuanceTime;
    }
}

