/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.criteria;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.ArchiveCutoffOrigin;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import de.governikus.csl.validation.revocation.criteria.RevocationValueTrustCheckCertProcessor;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.tslextension.ValMethodOCSP;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValueTrustCheck
extends AbstractValidationCriterion<RevocationValueData, RevocationValueValidationResult, RevocationValueValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationValueTrustCheck.class);

    @Override
    public void verify(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        BaseCertificateSignature<?> certificateToCheck = context.getCertificateToCheck();
        Date dateToCompare = null;
        RevocationValue revocationValue = signature.getValue();
        if (revocationValue.getOcspValue() != null) {
            dateToCompare = this.getArchiveCutOffByCert(certificateToCheck);
            if (dateToCompare == null) {
                dateToCompare = this.getArchiveCutOffByOCSPResp(revocationValue);
                if (dateToCompare == null) {
                    dateToCompare = this.getArchiveCutOffByTL(certificateToCheck);
                    if (dateToCompare == null) {
                        result.setArchiveCutoffOrigin(ArchiveCutoffOrigin.NONE);
                    } else {
                        result.setArchiveCutoffOrigin(ArchiveCutoffOrigin.OFFICIAL_TL);
                    }
                } else {
                    result.setArchiveCutoffOrigin(ArchiveCutoffOrigin.OCSP_RESPONSE);
                }
            } else {
                result.setArchiveCutoffOrigin(ArchiveCutoffOrigin.GOVERNIKUS_TL);
            }
            result.setArchiveCutoff(dateToCompare);
        } else {
            dateToCompare = this.parseExpiredCertsOnCRL(revocationValue.getCrlValue());
        }
        ValidationResult vr = certificateToCheck.process(new RevocationValueTrustCheckCertProcessor(context.getRevocationDate(), dateToCompare, signature.getIssuanceTime()));
        result.setRevocationValueTrustCheckResult(vr);
    }

    private Date getArchiveCutOffByTL(BaseCertificateSignature<?> certificateToCheck) {
        return Optional.ofNullable(certificateToCheck.getIssuerServiceInformation()).map(ServiceInformation::getExpiredCertsRevocationInfo).orElse(null);
    }

    private Date getArchiveCutOffByCert(BaseCertificateSignature<?> certificateToCheck) {
        return Optional.ofNullable(certificateToCheck.getIssuerServiceInformation()).map(ServiceInformation::getValMethodOCSP).map(ValMethodOCSP::getArchiveCutOff).orElse(null);
    }

    private Date getArchiveCutOffByOCSPResp(RevocationValue revocationValue) {
        return revocationValue.getArchiveCutoffDate();
    }

    @Override
    public boolean isApplicable(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        BaseCertificateSignature<?> certificateToCheck = context.getCertificateToCheck();
        if (certificateToCheck == null) {
            result.setRevocationValueTrustCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"revocation_value_trust_not_required"));
            return false;
        }
        ValidationPolicyType policy = context.getPolicy();
        if (!policy.isRevocationValueTrustRequired().booleanValue()) {
            result.setRevocationValueTrustCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
            return false;
        }
        return true;
    }

    private Date parseExpiredCertsOnCRL(X509CRL crlValue) {
        byte[] expiredCertsOnCRLExtension;
        if (crlValue != null && (expiredCertsOnCRLExtension = crlValue.getExtensionValue("2.5.29.60")) != null) {
            try {
                ASN1OctetString instance = ASN1OctetString.getInstance((Object)expiredCertsOnCRLExtension);
                expiredCertsOnCRLExtension = instance.getOctets();
            }
            catch (Exception e) {
                LOGGER.debug("Can't parse ExpiredCertsOnCRL-Extension: {}", (Object)e.getMessage());
                return null;
            }
            try {
                ASN1GeneralizedTime idp = ASN1GeneralizedTime.getInstance((Object)expiredCertsOnCRLExtension);
                return idp.getDate();
            }
            catch (Exception e) {
                LOGGER.debug("Can't parse ExpiredCertsOnCRL-Extension: {}", (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }
}

