/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import java.security.cert.X509CRL;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValueIssuerCheck
extends AbstractValidationCriterion<RevocationValueData, RevocationValueValidationResult, RevocationValueValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationValueIssuerCheck.class);

    @Override
    public void verify(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        RevocationValue value = signature.getValue();
        X509CRL crl = value.getCrlValue();
        if (crl != null) {
            boolean sameIssuer;
            X500Principal certIssuer = value.getCertificateToCheck().getIssuerX500Principal();
            X500Principal crlIssuer = crl.getIssuerX500Principal();
            boolean indirect = false;
            byte[] issuingDistributionPointData = crl.getExtensionValue("2.5.29.28");
            if (issuingDistributionPointData != null) {
                try {
                    ASN1OctetString instance = ASN1OctetString.getInstance((Object)issuingDistributionPointData);
                    issuingDistributionPointData = instance.getOctets();
                }
                catch (Exception instance) {
                    // empty catch block
                }
                try {
                    IssuingDistributionPoint idp = IssuingDistributionPoint.getInstance((Object)issuingDistributionPointData);
                    indirect = idp.isIndirectCRL();
                }
                catch (Exception e) {
                    LogHelper.logException((String)"Can't parse issuing distribution point", (Logger)LOGGER, (Throwable)e);
                }
            }
            if ((sameIssuer = certIssuer.equals(crlIssuer)) || indirect) {
                result.setCRLIssuerCheckResult(SVPFactory.createResultOk());
            } else {
                result.setCRLIssuerCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"revocation_values_crl_issuer_mismatch"}));
            }
        }
    }

    @Override
    public boolean isApplicable(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        RevocationValue value = signature.getValue();
        return value.getCrlValue() != null && value.getCertificateToCheck() != null;
    }
}

