/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class RevocationValueDatesCheck
extends AbstractValidationCriterion<RevocationValueData, RevocationValueValidationResult, RevocationValueValidationContext> {
    private static final long ALLOWED_DELTA = 1000L;
    private static final long ALLOWED_DELTA_NEXT_UPDATE = 3000L;

    @Override
    public void verify(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        ArrayList<ValidationMessageCode> codes = new ArrayList<ValidationMessageCode>();
        this.checkThisUpdate(signature.getThisUpdate(), codes);
        this.checkNextUpdate(signature, context, codes);
        ValidationResult res = null;
        res = codes.isEmpty() ? SVPFactory.createResultOk() : SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, codes, (MinorResult)MinorResult.FORMAT_FAILURE);
        result.setUpdateValueCheckResult(res);
    }

    private void checkNextUpdate(RevocationValueData signature, RevocationValueValidationContext context, List<ValidationMessageCode> codes) {
        Date nextUpdate = signature.getNextUpdate();
        if (nextUpdate == null) {
            return;
        }
        Date thisUpdate = signature.getThisUpdate();
        if (thisUpdate != null && thisUpdate.equals(nextUpdate)) {
            return;
        }
        BaseCertificateSignature<?> certificateToCheck = context.getCertificateToCheck();
        if (certificateToCheck == null) {
            return;
        }
        boolean checkNextUpdate = Optional.ofNullable(certificateToCheck.getIssuerServiceInformation()).map(x -> x.getValMethodOCSP()).map(x -> x.isCheckFreshness()).orElse(true);
        if (!checkNextUpdate) {
            return;
        }
        Date certBestPOE = context.getCertBestPOE().getDate();
        if (certBestPOE.getTime() > nextUpdate.getTime() + 3000L && signature.getValue().getSource() == InformationSource.ONLINE) {
            codes.add(SVPFactory.createMessageCode((String)"revocation_values_past_next_update", (Object[])new Object[]{nextUpdate}));
        }
    }

    private void checkThisUpdate(Date thisUpdate, List<ValidationMessageCode> codes) {
        Date now = new Date();
        if (thisUpdate != null && now.getTime() + 1000L < thisUpdate.getTime()) {
            codes.add(SVPFactory.createMessageCode((String)"revocation_values_future_this_update", (Object[])new Object[]{thisUpdate}));
        }
    }
}

