/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.RevocationStatus;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLReason;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValueBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationValueBuilder.class);

    public RevocationValue buildCRLResponse(TimedRevocationRequestResponse<X509CRL> crl, X509CertificateBaseFacade<?> userCert) {
        RevocationValue rv = this.buildCRLResponse((X509CRL)crl.getResponse(), userCert, null);
        rv.setRequestDuration(crl.getRequestDuration());
        return rv;
    }

    public RevocationValue buildCRLResponse(X509CRL crl, X509CertificateBaseFacade<?> userCert, List<TypedDate> poes) {
        RevocationValue rv = new RevocationValue();
        rv.setCrlValue(crl);
        rv.setNextUpdate(crl.getNextUpdate());
        rv.setThisUpdate(crl.getThisUpdate());
        rv.setCreationDate(crl.getThisUpdate());
        rv.setPoes(poes);
        X509CRLEntry entry = null;
        if (userCert != null) {
            entry = crl.getRevokedCertificate(userCert.getSerialNumber());
        }
        if (entry != null && this.issuerMatching(entry, userCert, crl.getIssuerX500Principal())) {
            rv.setStatus(RevocationStatus.REVOKED);
            rv.setRevocationDate(entry.getRevocationDate());
            CRLReason revocationReason = entry.getRevocationReason();
            if (revocationReason != null) {
                rv.setReason(de.governikus.csl.uom.validate.commons.CRLReason.valueOf((String)revocationReason.name()));
            }
        } else {
            rv.setStatus(RevocationStatus.OK);
        }
        return rv;
    }

    private boolean issuerMatching(X509CRLEntry entry, X509CertificateBaseFacade<?> userCert, X500Principal crlIssuer) {
        X500Principal certIssuer = userCert.getIssuerX500Principal();
        X500Principal entryIssuer = entry.getCertificateIssuer();
        if (entryIssuer != null) {
            return entryIssuer.equals(certIssuer);
        }
        return crlIssuer.equals(certIssuer);
    }

    public RevocationValue buildOCSPResponse(TimedRevocationRequestResponse<OCSPResp> resp) {
        RevocationValue rv = this.buildOCSPResponse((OCSPResp)resp.getResponse(), null);
        rv.setRequestDuration(resp.getRequestDuration());
        return rv;
    }

    public RevocationValue buildOCSPResponse(OCSPResp oresp, List<TypedDate> list) {
        if (oresp == null) {
            return null;
        }
        RevocationValue rv = new RevocationValue();
        rv.setOcspValue(oresp);
        rv.setResponseStatus(oresp.getStatus());
        rv.setPoes(list);
        BasicOCSPResp resp = null;
        try {
            Object responseObject = oresp.getResponseObject();
            if (responseObject != null) {
                resp = (BasicOCSPResp)responseObject;
            }
        }
        catch (OCSPException e1) {
            LOGGER.warn("Error while processing OSCP response.", (Throwable)e1);
        }
        CertificateStatus status = null;
        SingleResp singleResp = this.getSingleResp(resp);
        if (resp == null || singleResp == null) {
            return rv;
        }
        rv.setCreationDate(resp.getProducedAt());
        if (singleResp != null) {
            rv.setNextUpdate(singleResp.getNextUpdate());
            rv.setThisUpdate(singleResp.getThisUpdate());
            status = singleResp.getCertStatus();
        }
        if (status == null) {
            rv.setStatus(RevocationStatus.OK);
        } else if (status instanceof RevokedStatus) {
            RevokedStatus rStatus = (RevokedStatus)status;
            rv.setRevocationDate(rStatus.getRevocationTime());
            try {
                rv.setReason(de.governikus.csl.uom.validate.commons.CRLReason.fromCode((int)rStatus.getRevocationReason()));
            }
            catch (IllegalStateException e) {
                LOGGER.info("Certificate is revoked but no revocation status is given");
                rv.setReason(de.governikus.csl.uom.validate.commons.CRLReason.UNSPECIFIED);
            }
            rv.setStatus(RevocationStatus.REVOKED);
        } else if (status instanceof UnknownStatus) {
            rv.setStatus(RevocationStatus.UNKNOWN);
        }
        ASN1ObjectIdentifier archiveCutoffOID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.6");
        Extension archiveCutoff = resp.getExtension(archiveCutoffOID);
        if (archiveCutoff == null) {
            archiveCutoff = singleResp.getExtension(archiveCutoffOID);
        }
        if (archiveCutoff != null) {
            try {
                ASN1GeneralizedTime time = ASN1GeneralizedTime.getInstance((Object)archiveCutoff.getExtnValue().getOctets());
                Date d = time.getDate();
                rv.setArchiveCutoffDate(d);
            }
            catch (ParseException e) {
                LOGGER.warn("Error while processing arcive cutoff date.", (Throwable)e);
            }
        }
        return rv;
    }

    protected SingleResp getSingleResp(BasicOCSPResp brep) {
        if (brep == null) {
            return null;
        }
        SingleResp[] responses = brep.getResponses();
        if (responses.length > 0) {
            return responses[0];
        }
        return null;
    }

    public boolean matches(OCSPResp response, X509CertificateBaseFacade<?> userCert, AlgorithmManager algorithmManager) {
        BasicOCSPResp rv = null;
        try {
            Object responseObject = response.getResponseObject();
            if (responseObject != null) {
                rv = (BasicOCSPResp)responseObject;
            }
        }
        catch (OCSPException e1) {
            LOGGER.error("Error while processing OSCP response. Invalid result is returned.", (Throwable)e1);
        }
        if (rv == null) {
            return false;
        }
        String lastOID = null;
        SingleResp[] srs = rv.getResponses();
        MessageDigest md = null;
        for (SingleResp sr : srs) {
            CertificateID certID = sr.getCertID();
            if (!certID.getSerialNumber().equals(userCert.getSerialNumber())) continue;
            String oid = certID.getHashAlgOID().getId();
            if (lastOID == null || !lastOID.equals(oid)) {
                DigestAlgorithm digestAlgorithm = algorithmManager.getDigestAlgorithmByOID(oid);
                try {
                    md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    LOGGER.warn("Error while processing certificate.", (Throwable)e);
                    continue;
                }
                lastOID = oid;
            }
            byte[] searchIssuerNameHash = md.digest(userCert.getIssuerX500Principal().getEncoded());
            byte[] issuerNameHash = certID.getIssuerNameHash();
            md.reset();
            if (!Arrays.equals(searchIssuerNameHash, issuerNameHash)) continue;
            return true;
        }
        return false;
    }
}

