/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.exceptions.ValidationCheckException;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.QualityResult;
import de.governikus.csl.uom.validate.RevocationFreshnessCheckSettings;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.utils.DateUtil;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import de.governikus.csl.validation.revocation.service.RevocationValueCacheTimeCalculator;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.tslextension.ValMethodOCSP;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;

public class RevocationFreshnessCheck
extends AbstractValidationCriterion<RevocationValueData, RevocationValueValidationResult, RevocationValueValidationContext> {
    private RevocationValueCacheTimeCalculator timeCalculator = new RevocationValueCacheTimeCalculator();

    @Override
    public void verify(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        Date nextUpdate = signature.getNextUpdate();
        Date thisUpdate = signature.getThisUpdate();
        Date issuanceDate = signature.getIssuanceTime();
        ValidationPolicyType policy = context.getPolicy();
        RevocationFreshnessCheckSettings revocationFreshnessCheckSettings = policy.getRevocationFreshnessCheckSettings();
        try {
            this.checkNextUpdate(nextUpdate);
            Date validationDate = this.determineValidationDate(context, revocationFreshnessCheckSettings);
            long maxAge = this.calculateMaxRevocationValueAge((ValidatePolicy)policy, thisUpdate, nextUpdate, context, signature);
            this.checkFreshness(issuanceDate, validationDate, maxAge, signature.getValue());
            this.setResult(result, SVPFactory.createResultOk());
        }
        catch (ValidationCheckException e) {
            this.setResult(result, SVPFactory.create((MajorTotalResult)e.getMajor(), (MinorResult)e.getMinor(), (String[])e.getValidationMessagesCodes()));
        }
    }

    private boolean isQES(RevocationValueValidationContext context) {
        return Optional.of(context).map(RevocationValueValidationContext::getCertificateToCheck).map(BaseCertificateSignature::getQualityResult).filter(QualityResult::isQES).isPresent();
    }

    private long calculateMaxRevocationValueAge(ValidatePolicy policy, Date thisUpdate, Date nextUpdate, RevocationValueValidationContext context, RevocationValueData signature) {
        long maxAge = 0L;
        RevocationFreshnessCheckSettings revocationFreshnessCheckSettings = policy.getRevocationFreshnessCheckSettings();
        if (!this.isQES(context)) {
            if (thisUpdate != null && nextUpdate != null && !thisUpdate.equals(nextUpdate)) {
                maxAge = nextUpdate.getTime() - thisUpdate.getTime();
            } else if (RevocationFreshnessCheckSettings.CHECK_AT_EXISTENCE.equals((Object)revocationFreshnessCheckSettings)) {
                maxAge = policy.getMaxRevocationValueAge();
            }
        }
        if (signature.getValue() != null && signature.getValue().getSource() == InformationSource.CACHE) {
            maxAge += this.timeCalculator.chooseMaxCacheTime(context.getCertificateToCheck(), context);
        }
        return maxAge;
    }

    private void setResult(RevocationValueValidationResult result, ValidationResult validationResultImpl) {
        result.setFreshnessCheckResult(validationResultImpl);
    }

    @Override
    public boolean isApplicable(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        ValMethodOCSP valMethodOCSP;
        if (RevocationFreshnessCheckSettings.SKIP_CHECK.equals((Object)context.getPolicy().getRevocationFreshnessCheckSettings())) {
            this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
            return false;
        }
        BaseCertificateSignature<?> certificateToCheck = context.getCertificateToCheck();
        if (certificateToCheck == null) {
            return true;
        }
        ServiceInformation issuerServiceInformation = certificateToCheck.getIssuerServiceInformation();
        if (issuerServiceInformation != null && (valMethodOCSP = issuerServiceInformation.getValMethodOCSP()) != null && !valMethodOCSP.isCheckFreshness()) {
            this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_tl_extension"));
            return false;
        }
        return true;
    }

    private Date determineValidationDate(RevocationValueValidationContext context, RevocationFreshnessCheckSettings revocationFreshnessCheckSettings) throws ValidationCheckException {
        if (revocationFreshnessCheckSettings == null) {
            throw new ValidationCheckException(MajorTotalResult.INDETERMINATE, MinorResult.GENERIC, new String[]{"policy_no_freshness_check_settings"});
        }
        if (revocationFreshnessCheckSettings.equals((Object)RevocationFreshnessCheckSettings.CHECK_AT_EXISTENCE)) {
            return context.getValidationDate();
        }
        if (revocationFreshnessCheckSettings.equals((Object)RevocationFreshnessCheckSettings.CHECK_AT_POE)) {
            return Optional.ofNullable(context.getCertBestPOE()).map(TypedDate::getDate).orElse(context.getBestSigningTime().getDate());
        }
        throw new ValidationCheckException(MajorTotalResult.INDETERMINATE, MinorResult.GENERIC, new String[]{"policy_skip_check_revocation_freshness"});
    }

    private void checkNextUpdate(Date nextUpdate) throws ValidationCheckException {
        if (nextUpdate != null && nextUpdate.after(DateUtil.DATE_FOR_FINAL_REVOCATION_VALUES)) {
            throw new ValidationCheckException(MajorTotalResult.NOT_VALIDATED, null, new String[]{"revocation_values_final_value"});
        }
    }

    private void checkFreshness(Date issuanceDate, Date validationDate, long maxAge, RevocationValue revocationValue) throws ValidationCheckException {
        if (issuanceDate.toInstant().truncatedTo(ChronoUnit.SECONDS).toEpochMilli() < validationDate.toInstant().truncatedTo(ChronoUnit.SECONDS).toEpochMilli() - maxAge) {
            if (revocationValue != null && revocationValue.getOcspValue() != null) {
                throw new ValidationCheckException(MajorTotalResult.INDETERMINATE, MinorResult.TRY_LATER, new String[]{"revocation_values_ocsp_too_old"});
            }
            throw new ValidationCheckException(MajorTotalResult.INDETERMINATE, MinorResult.TRY_LATER, new String[0]);
        }
    }
}

