/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.RevocationStatus;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencedCertificateHashCheck
extends AbstractValidationCriterion<RevocationValueData, RevocationValueValidationResult, RevocationValueValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencedCertificateHashCheck.class);
    private static final ASN1ObjectIdentifier CERT_HASH_IDENTIFIER = new ASN1ObjectIdentifier("1.3.36.8.3.13");

    @Override
    public void verify(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        LOGGER.debug("Verify hash of certificate in ocsp value");
        AlgorithmManager algorithmManager = context.getConfiguration().getAlgorithmManager();
        RevocationValue revocationValue = signature.getValue();
        OCSPResp ocspValue = revocationValue.getOcspValue();
        ValidationPolicyType policy = context.getPolicy();
        if (ocspValue != null) {
            try {
                BasicOCSPResp basicResp;
                SingleResp[] responses;
                SingleResp response;
                Object responseObject = ocspValue.getResponseObject();
                Extension certHashExtension = null;
                if (responseObject != null && (certHashExtension = (response = (responses = (basicResp = (BasicOCSPResp)responseObject).getResponses())[0]).getExtension(CERT_HASH_IDENTIFIER)) == null) {
                    certHashExtension = basicResp.getExtension(CERT_HASH_IDENTIFIER);
                }
                if (certHashExtension != null) {
                    CertHash certHash = CertHash.getInstance((Object)ASN1Sequence.getInstance((Object)certHashExtension.getExtnValue().getOctets()));
                    byte[] certificateHash = certHash.getCertificateHash();
                    AlgorithmIdentifier hashAlgorithm = certHash.getHashAlgorithm();
                    DigestAlgorithm algorithm = algorithmManager.getDigestAlgorithmByOID(hashAlgorithm.getAlgorithm().getId());
                    MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)algorithm.getJCAName());
                    md.update(revocationValue.getCertificateToCheck().getEncoded());
                    byte[] digest = md.digest();
                    boolean b = MessageDigest.isEqual(digest, certificateHash);
                    if (b) {
                        result.setCertHashCheckResult(SVPFactory.createResultOk());
                    } else {
                        result.setCertHashCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.HASH_FAILURE, (String[])new String[]{"revocation_values_cert_hash_mismatch"}));
                    }
                } else {
                    boolean certHashInOCSPRequired = policy.isCertHashInOCSPRequired();
                    if (revocationValue.getStatus() == RevocationStatus.UNKNOWN) {
                        result.setCertHashCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null));
                    } else if (certHashInOCSPRequired) {
                        result.setCertHashCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.HASH_FAILURE, (String[])new String[]{"revocation_values_cert_hash_absent"}));
                    } else {
                        result.setCertHashCheckResult(SVPFactory.createResultOk());
                    }
                }
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | CertificateEncodingException | OCSPException e) {
                LOGGER.error("Error during verifying certificate hash in ocsp value", e);
                result.setCertHashCheckResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"error_verify_certhash"}));
            }
        }
    }

    @Override
    public boolean isApplicable(RevocationValueData signature, RevocationValueValidationResult result, RevocationValueValidationContext context) {
        RevocationValue revocationValue = signature.getValue();
        return revocationValue.getCertificateToCheck() != null;
    }
}

