/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.certStore.CertificateData;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.RevocationValueValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.dataExtractor.RevocationValueDataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.RevocationValueData;
import de.governikus.csl.validation.revocation.RevocationValueValidationContext;
import java.io.ByteArrayInputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public abstract class AbstractRevocationValuePlugin
extends AbstractDocumentPlugin<RevocationValueData, RevocationValueData, ObjectValidationResult, RevocationValueValidationResult, RevocationValueValidationContext> {
    public AbstractRevocationValuePlugin() {
        super(RevocationValueData.class, RevocationValueValidationContext.class);
    }

    public RevocationValueData parseDocument(RevocationValue value, CertStore certStore) throws ValidatePluginException {
        AlgorithmManager algorithmManager = this.configuration.getAlgorithmManager();
        RevocationValueData result = new RevocationValueData();
        result.setValue(value);
        result.setIssuanceTime(value.getCreationDate());
        result.setNextUpdate(value.getNextUpdate());
        result.setThisUpdate(value.getThisUpdate());
        if (value.getOcspValue() != null) {
            SignatureAlgorithm signatureAlgorithm;
            OCSPResp resp = value.getOcspValue();
            BasicOCSPResp doc = null;
            try {
                Object responseObject = resp.getResponseObject();
                if (responseObject != null) {
                    doc = (BasicOCSPResp)responseObject;
                }
            }
            catch (OCSPException e1) {
                throw new ValidatePluginException(this, "Can't parse OCSP response", e1);
            }
            if (doc == null) {
                throw new ValidatePluginException(this, "The ocsp response does not contain a response object");
            }
            result.setName("OCSP-Response");
            AlgorithmIdentifier signatureAlgorithmID = doc.getSignatureAlgorithmID();
            try {
                signatureAlgorithm = algorithmManager.getSignatureAlgorithm(signatureAlgorithmID);
            }
            catch (CoreException e1) {
                throw new ValidatePluginException(this, "Can't parse signature algorithm", e1);
            }
            result.setSignatureAlgorithm(signatureAlgorithm);
            result.setSignatureValue(doc.getSignature());
            result.setType(SignedObjectType.OCSP);
            byte[] data = doc.getTBSResponseData();
            ByteArrayDocument bais = new ByteArrayDocument(data);
            result.setSignedContent((Document)bais);
            Date producedAt = doc.getProducedAt();
            if (producedAt != null) {
                result.setSigningTime(SVPFactory.createTypedDate((Date)producedAt, (DateType)DateType.CLAIMED_SIGNING_TIME));
            }
            X509CertificateImpl signerCert = null;
            RespID respID = doc.getResponderId();
            X509CertificateHolder[] tmpCerts = doc.getCerts();
            if (tmpCerts != null && tmpCerts.length > 0) {
                try {
                    boolean first = true;
                    for (X509CertificateHolder tmpCert : tmpCerts) {
                        CertificateFactory cf = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
                        X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(tmpCert.getEncoded()));
                        boolean signatureValid = doc.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(x509Cert.getPublicKey()));
                        if (signatureValid || first) {
                            signerCert = new X509CertificateImpl(x509Cert);
                            if (signatureValid) break;
                        }
                        first = false;
                    }
                }
                catch (Exception e) {
                    throw new ValidatePluginException(this, "Can't parse document", e);
                }
            } else if (respID != null && certStore != null) {
                ResponderID responderID = respID.toASN1Primitive();
                X500Name name = null;
                byte[] keyHash = null;
                if (responderID != null) {
                    name = responderID.getName();
                    keyHash = responderID.getKeyHash();
                }
                if (name != null) {
                    List matchingCertificates;
                    CertStoreResponse signingCertificates;
                    X500Principal p = null;
                    try {
                        byte[] encoded = name.getEncoded("DER");
                        p = new X500Principal(encoded);
                    }
                    catch (Exception encoded) {
                        // empty catch block
                    }
                    if (p != null && (signingCertificates = certStore.getCertificates(p)) != null && (matchingCertificates = signingCertificates.getMatchingCertificates()) != null && !matchingCertificates.isEmpty()) {
                        signerCert = new X509CertificateImpl(((CertificateData)matchingCertificates.get(0)).getCertificate());
                    }
                } else if (keyHash != null) {
                    // empty if block
                }
            }
            result.setSigningCertificate(signerCert);
        } else {
            X509CRL crl = value.getCrlValue();
            result.setName("CRL-Response");
            SignatureAlgorithm signatureAlgorithm = algorithmManager.getSignatureAlgorithmByJcaOidOrUrl(crl.getSigAlgName(), crl.getSigAlgOID(), null);
            result.setSignatureAlgorithm(signatureAlgorithm);
            result.setSignatureValue(crl.getSignature());
            result.setType(SignedObjectType.CRL);
            try {
                byte[] data = crl.getTBSCertList();
                ByteArrayDocument bais = new ByteArrayDocument(data);
                result.setSignedContent((Document)bais);
            }
            catch (CRLException e) {
                this.logger.warn("Cannot process data. No signed content set.", (Throwable)e);
            }
            result.setSigningTime(SVPFactory.createTypedDate((Date)crl.getThisUpdate(), (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        return result;
    }

    @Override
    public DataExtractor<? super RevocationValueData, ? super RevocationValueValidationResult> getSignatureDataExtractor() {
        return new RevocationValueDataExtractor();
    }

    @Override
    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        return SVPFactory.createObjectValidationResult((String)this.getID());
    }

    @Override
    public RevocationValueValidationResult createSignatureValidationResultStructure() {
        RevocationValueValidationResult res = new RevocationValueValidationResult();
        return res;
    }

    @Override
    public RevocationValueValidationContext createContext(RevocationValueData signature, ValidationPolicyType policy) {
        return new RevocationValueValidationContext(policy);
    }
}

