/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality2.impl;

import de.governikus.csl.tsl.qualifier.KeyUsageCriterion;
import de.governikus.csl.tsl.qualifier.PolicyCriterion;
import de.governikus.csl.tsl.qualifier.Qualifier;
import de.governikus.csl.tsl.qualifier.QualifierCriterion;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QualifierCriteriaFilter
implements Predicate<Qualifier> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QualifierCriteriaFilter.class);
    private static final String LOG_FORMAT = "{%s/%s/%s}";
    private X509Certificate ee;

    public QualifierCriteriaFilter(X509Certificate ee) {
        this.ee = ee;
    }

    public QualifierCriteriaFilter(X509CertificateBaseFacade<?> ee) {
        if (ee instanceof X509CertificateImpl) {
            this.ee = (X509CertificateImpl)ee;
        }
    }

    @Override
    public boolean test(Qualifier qualifier) {
        if (this.ee == null) {
            return false;
        }
        boolean isApplicable = qualifier.isApplicable(this.ee);
        if (log.isDebugEnabled()) {
            if (isApplicable) {
                log.debug("Applicable qualifier for [{}]: {}", (Object)this.ee.getSubjectX500Principal(), (Object)String.format(LOG_FORMAT, qualifier.getAssertion(), this.getCriteriasLogText(qualifier.getCriteria()), qualifier.getQualifiers()));
            } else {
                log.debug("Inapplicable qualifier for [{}]: {}", (Object)this.ee.getSubjectX500Principal(), (Object)String.format(LOG_FORMAT, qualifier.getAssertion(), this.getCriteriasLogText(qualifier.getCriteria()), qualifier.getQualifiers()));
            }
        }
        return isApplicable;
    }

    private String getCriteriasLogText(List<QualifierCriterion> criterias) {
        return criterias.stream().map(this::getCriteriaLogText).collect(Collectors.joining(","));
    }

    private String getCriteriaLogText(QualifierCriterion criteria) {
        if (criteria instanceof KeyUsageCriterion) {
            return ((KeyUsageCriterion)criteria).getRequiredSettings().toString();
        }
        if (criteria instanceof PolicyCriterion) {
            return ((PolicyCriterion)criteria).getRequiredPolicyOIDs().toString();
        }
        return "[]";
    }
}

