/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality2.impl;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.Quality;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.SignatureQualityResult;
import de.governikus.csl.validation.quality2.QualityContext;
import de.governikus.csl.validation.quality2.SignatureQualityProcessor;

public class DefaultSignatureQualityProcessor
implements SignatureQualityProcessor {
    private static final Boolean[][] QSCD_RESULT_MAPPING_TABLE = new Boolean[][]{{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}, {Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}};
    private int certQcRowIndex;
    private int qualifierColIndex;

    public Boolean determinePrivateKeyOnQSCDorSSCD(QualityContext context) {
        if (context.isBeforeEidas() && context.illegalSigGQualifierCombination() || !context.isBeforeEidas() && context.illegalEidasQualifierCombination()) {
            return null;
        }
        this.certQcRowIndex = 1;
        this.qualifierColIndex = 1;
        if (context.isBeforeEidas()) {
            if (context.getQcStatements().contains("0.4.0.1862.1.4") || context.hasPolicyQcpPlus()) {
                this.certQcRowIndex = 0;
            }
            if (context.asInCertOrNoSigGIndication()) {
                this.qualifierColIndex = 1;
            } else if (context.getQualifiers().contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD")) {
                this.qualifierColIndex = 0;
            } else if (context.getQualifiers().contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD")) {
                this.qualifierColIndex = 2;
            }
        } else {
            if (context.getQcStatements().contains("0.4.0.1862.1.4")) {
                this.certQcRowIndex = 0;
            }
            if (context.asInCertOrNoEidasIndication()) {
                this.qualifierColIndex = 1;
            } else if (context.getQualifiers().contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD") || context.getQualifiers().contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf")) {
                this.qualifierColIndex = 0;
            } else if (context.getQualifiers().contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD")) {
                this.qualifierColIndex = 2;
            }
        }
        return QSCD_RESULT_MAPPING_TABLE[this.certQcRowIndex][this.qualifierColIndex];
    }

    @Override
    public SignatureQualityResult process(QualityContext certificateQualityContext) {
        Boolean keyOnQSCDorSSCD = this.determinePrivateKeyOnQSCDorSSCD(certificateQualityContext);
        SignatureQualityResult result = new SignatureQualityResult();
        if (keyOnQSCDorSSCD == null) {
            result.setQuality(Quality.INDETERMINATE);
            result.setMajor(MajorTotalResult.INDETERMINATE);
            result.getMessages().add(SVPFactory.createMessageCode((String)"quality_contradicting_qscd_info_from_tl"));
        } else if (keyOnQSCDorSSCD.booleanValue()) {
            result.setQuality(Quality.QC);
            result.setMajor(MajorTotalResult.TOTAL_PASSED);
            result.getMessages().add(SVPFactory.createMessageCode((String)"quality_qc"));
        } else if (this.certQcRowIndex == 1 && this.qualifierColIndex == 1) {
            result.setQuality(Quality.AC);
            result.setMajor(MajorTotalResult.TOTAL_FAILED);
            if (certificateQualityContext.hasQcStatusAsInCert()) {
                result.getMessages().add(SVPFactory.createMessageCode((String)"quality_statusasincert_and_qcsscd_not_present"));
            } else if (TLType.OFFICIAL.equals((Object)certificateQualityContext.getTrustedListType())) {
                result.getMessages().add(SVPFactory.createMessageCode((String)"quality_no_qcsd_indication"));
            }
        } else {
            result.setQuality(Quality.AC);
            result.setMajor(MajorTotalResult.TOTAL_FAILED);
            result.getMessages().add(SVPFactory.createMessageCode((String)"quality_qcnoqscd_or_qcnosscd"));
        }
        return result;
    }

    public static DefaultSignatureQualityProcessor newInstance() {
        return new DefaultSignatureQualityProcessor();
    }
}

