/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality2.impl;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.CertificateQualityConstraints;
import de.governikus.csl.validate.svp.CertificateQualityResult;
import de.governikus.csl.validate.svp.QualityResult;
import de.governikus.csl.validate.svp.SignatureQualityResult;
import de.governikus.csl.validation.quality.cert.model.constant.Constants;
import de.governikus.csl.validation.quality2.CertificateQualityProcessor;
import de.governikus.csl.validation.quality2.ConcernProcessor;
import de.governikus.csl.validation.quality2.QualityContext;
import de.governikus.csl.validation.quality2.QualityProcessor;
import de.governikus.csl.validation.quality2.SignatureQualityProcessor;
import de.governikus.csl.validation.quality2.impl.QualifierCriteriaFilter;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQualityProcessor
implements QualityProcessor<QualityResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultQualityProcessor.class);
    private CertificateQualityProcessor certificateQualityProcessor;
    private SignatureQualityProcessor signatureQualityProcessor;
    private ConcernProcessor concernProcessor;

    @Override
    public QualityResult process(BaseCertificateSignature<?> cert, Deque<X509Data> chain, Date referenceDate) {
        log.debug("Validate quality");
        Object ee = cert.getCert();
        ServiceInformation serviceInfo = this.findServiceInfo(chain);
        boolean beforeEidas = referenceDate.before(Constants.EIDAS_START);
        ExtendedTLInformation tlInfo = this.getTlInfo(cert, chain);
        QualityContext context = QualityContext.init(new QualifierCriteriaFilter((X509CertificateBaseFacade<?>)ee), ee.getQCStatements(), ee.getCertificatePolicies(), serviceInfo, tlInfo, beforeEidas);
        QualityResult qualityResult = new QualityResult();
        this.certificateQuality(context, qualityResult);
        this.signatureQuality(context, qualityResult);
        if (!MajorTotalResult.TOTAL_PASSED.equals((Object)qualityResult.getCertificateQualityResult().getMajor())) {
            qualityResult.getSignatureQualityResult().getMessages().remove(SVPFactory.createMessageCode((String)"quality_qc"));
        }
        this.concernProcessor.checkWarnings(qualityResult.getCertificateQualityResult(), cert, serviceInfo, tlInfo);
        cert.setQualityResult(qualityResult);
        return qualityResult;
    }

    private void certificateQuality(QualityContext context, QualityResult qualityResult) {
        log.trace("Validate certificate quality");
        CertificateQualityResult certificateQualityResult = this.certificateQualityProcessor.process(context);
        CertificateQualityConstraints constraints = new CertificateQualityConstraints();
        constraints.getQCStatements().addAll(context.getQcStatements());
        constraints.getQualifiers().addAll(context.getQualifiers());
        constraints.getAdditionalServiceInformations().addAll(context.getAdditionalServiceInformations());
        constraints.getCertificatePolicies().addAll(context.getPolicies());
        constraints.setServiceTypeIdentifier(context.getServiceTypeIdentifier());
        certificateQualityResult.setConstraints(constraints);
        qualityResult.setCertificateQualityResult(certificateQualityResult);
    }

    private void signatureQuality(QualityContext context, QualityResult qualityResult) {
        log.trace("Validate signature quality");
        SignatureQualityResult signatureQualityResult = this.signatureQualityProcessor.process(context);
        qualityResult.setSignatureQualityResult(signatureQualityResult);
    }

    private ServiceInformation findServiceInfo(Deque<X509Data> chain) {
        Iterator<X509Data> x509DataIterator = chain.descendingIterator();
        while (x509DataIterator.hasNext()) {
            X509Data x509Data = x509DataIterator.next();
            if (x509Data.getServiceInformation() == null) continue;
            return x509Data.getServiceInformation();
        }
        return null;
    }

    private ExtendedTLInformation getTlInfo(BaseCertificateSignature<?> cert, Deque<X509Data> chain) {
        X509Data x509Data;
        ExtendedTLInformation tlInfo = null;
        tlInfo = cert.getTslInformation();
        if (tlInfo != null) {
            return tlInfo;
        }
        Iterator<X509Data> descendingIterator = chain.descendingIterator();
        while (descendingIterator.hasNext() && (tlInfo = (x509Data = descendingIterator.next()).getTslInformation()) == null) {
        }
        return tlInfo;
    }

    @Generated
    public static DefaultQualityProcessorBuilder builder() {
        return new DefaultQualityProcessorBuilder();
    }

    @Generated
    public CertificateQualityProcessor getCertificateQualityProcessor() {
        return this.certificateQualityProcessor;
    }

    @Generated
    public SignatureQualityProcessor getSignatureQualityProcessor() {
        return this.signatureQualityProcessor;
    }

    @Generated
    public ConcernProcessor getConcernProcessor() {
        return this.concernProcessor;
    }

    @Generated
    public void setCertificateQualityProcessor(CertificateQualityProcessor certificateQualityProcessor) {
        this.certificateQualityProcessor = certificateQualityProcessor;
    }

    @Generated
    public void setSignatureQualityProcessor(SignatureQualityProcessor signatureQualityProcessor) {
        this.signatureQualityProcessor = signatureQualityProcessor;
    }

    @Generated
    public void setConcernProcessor(ConcernProcessor concernProcessor) {
        this.concernProcessor = concernProcessor;
    }

    @Generated
    public DefaultQualityProcessor(CertificateQualityProcessor certificateQualityProcessor, SignatureQualityProcessor signatureQualityProcessor, ConcernProcessor concernProcessor) {
        this.certificateQualityProcessor = certificateQualityProcessor;
        this.signatureQualityProcessor = signatureQualityProcessor;
        this.concernProcessor = concernProcessor;
    }

    @Generated
    public DefaultQualityProcessor() {
    }

    @Generated
    public static class DefaultQualityProcessorBuilder {
        @Generated
        private CertificateQualityProcessor certificateQualityProcessor;
        @Generated
        private SignatureQualityProcessor signatureQualityProcessor;
        @Generated
        private ConcernProcessor concernProcessor;

        @Generated
        DefaultQualityProcessorBuilder() {
        }

        @Generated
        public DefaultQualityProcessorBuilder certificateQualityProcessor(CertificateQualityProcessor certificateQualityProcessor) {
            this.certificateQualityProcessor = certificateQualityProcessor;
            return this;
        }

        @Generated
        public DefaultQualityProcessorBuilder signatureQualityProcessor(SignatureQualityProcessor signatureQualityProcessor) {
            this.signatureQualityProcessor = signatureQualityProcessor;
            return this;
        }

        @Generated
        public DefaultQualityProcessorBuilder concernProcessor(ConcernProcessor concernProcessor) {
            this.concernProcessor = concernProcessor;
            return this;
        }

        @Generated
        public DefaultQualityProcessor build() {
            return new DefaultQualityProcessor(this.certificateQualityProcessor, this.signatureQualityProcessor, this.concernProcessor);
        }

        @Generated
        public String toString() {
            return "DefaultQualityProcessor.DefaultQualityProcessorBuilder(certificateQualityProcessor=" + this.certificateQualityProcessor + ", signatureQualityProcessor=" + this.signatureQualityProcessor + ", concernProcessor=" + this.concernProcessor + ")";
        }
    }
}

