/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality2.impl;

import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.CertificateQualityResult;
import de.governikus.csl.validate.svp.InternationalizedString;
import de.governikus.csl.validate.svp.TSPInfo;
import de.governikus.csl.validation.quality2.ConcernProcessor;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultConcernProcessor
implements ConcernProcessor {
    @Override
    public void checkWarnings(CertificateQualityResult certificateQualityResult, BaseCertificateSignature<?> cert, ServiceInformation serviceInfo, ExtendedTLInformation tlInfo) {
        TSPInfo tspInformation;
        LDAPEntry entry;
        String organisation;
        if (tlInfo != null) {
            List reliabilityConcerns = Optional.ofNullable(tlInfo.getReliabilityConcerns()).orElse(Collections.emptyList());
            if (reliabilityConcerns.contains("tl_invalid_signature")) {
                certificateQualityResult.getMessages().add(SVPFactory.createMessageCode((String)"tl_invalid_signature"));
                certificateQualityResult.setMajor(MajorTotalResult.TOTAL_FAILED);
            }
            if (reliabilityConcerns.contains("tl_expired")) {
                certificateQualityResult.getMessages().add(SVPFactory.createMessageCode((String)"tl_expired"));
                certificateQualityResult.setMajor(MajorTotalResult.TOTAL_FAILED);
            }
        }
        if (serviceInfo != null && (organisation = (entry = new LDAPEntry(cert.getCert().getIssuerX500Principal())).getOrganisation()) != null && ((tspInformation = serviceInfo.getTspInformation()) == null || !this.isInList(organisation, tspInformation.getNames()) && !this.isInList(organisation, tspInformation.getTradeNames()) && TLType.OFFICIAL.equals((Object)certificateQualityResult.getTLType()))) {
            certificateQualityResult.getMessages().add(SVPFactory.createMessageCode((String)"quality_issuer_name_mismatch"));
        }
    }

    private boolean isInList(String organisation, List<InternationalizedString> names) {
        if (names == null) {
            return false;
        }
        for (InternationalizedString is : names) {
            String value = is.getValue();
            if (value == null || !value.equals(organisation)) continue;
            return true;
        }
        return false;
    }

    public static DefaultConcernProcessor newInstance() {
        return new DefaultConcernProcessor();
    }
}

