/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality2.impl;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.CertificateType;
import de.governikus.csl.uom.validate.Quality;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.CertificateQualityResult;
import de.governikus.csl.validation.quality2.CertificateQualityProcessor;
import de.governikus.csl.validation.quality2.QualityContext;
import de.governikus.csl.validation.quality2.impl.CertificateQualityCheckException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultCertificateQualityProcessor
implements CertificateQualityProcessor {
    @Override
    public CertificateQualityResult process(QualityContext certificateQualityContext) {
        CertificateQualityResult certificateQuality;
        block2: {
            certificateQuality = new CertificateQualityResult();
            certificateQuality.setTLType(certificateQualityContext.getTrustedListType());
            CertificateType certificateType = this.determineCertificateType(certificateQualityContext);
            certificateQuality.setCertificateType(certificateType);
            try {
                this.check(certificateQualityContext, certificateQuality);
            }
            catch (CertificateQualityCheckException e) {
                certificateQuality.setQuality(e.getQuality());
                certificateQuality.setMajor(e.getMajor());
                List<String> messages = e.getMessages();
                if (messages == null) break block2;
                List messageCodes = messages.stream().map(SVPFactory::createMessageCode).collect(Collectors.toList());
                certificateQuality.getMessages().addAll(messageCodes);
            }
        }
        this.setAssumedQuality(certificateQuality, certificateQualityContext);
        this.resetQualityAndTypeIfRequired(certificateQuality, certificateQualityContext);
        this.setTLSourceMsg(certificateQuality, certificateQualityContext);
        return certificateQuality;
    }

    private void setAssumedQuality(CertificateQualityResult certificateQuality, QualityContext context) {
        if (("http://uri.etsi.org/TrstSvc/Svctype/CA/QC".equals(context.getServiceTypeIdentifier()) || "http://uri.etsi.org/TrstSvc/Svctype/NationalRootCA-QC".equals(context.getServiceTypeIdentifier())) && TLType.OFFICIAL.equals((Object)context.getTrustedListType())) {
            certificateQuality.setAssumedQuality(Quality.QC);
        } else if (TLType.GOVERNIKUS.equals((Object)context.getTrustedListType()) || TLType.CUSTOM.equals((Object)context.getTrustedListType()) || "http://uri.etsi.org/TrstSvc/Svctype/CA/PKC".equals(context.getServiceTypeIdentifier()) && TLType.OFFICIAL.equals((Object)context.getTrustedListType())) {
            certificateQuality.setAssumedQuality(Quality.AC);
        } else {
            certificateQuality.setAssumedQuality(Quality.DC);
        }
    }

    private void resetQualityAndTypeIfRequired(CertificateQualityResult certificateQuality, QualityContext context) {
        if (!MajorTotalResult.TOTAL_PASSED.equals((Object)certificateQuality.getMajor())) {
            certificateQuality.setCertificateType(CertificateType.INDETERMINATE);
        }
        if (context.getTrustedListType() == null) {
            certificateQuality.setQuality(Quality.DC);
            certificateQuality.setAssumedQuality(Quality.DC);
            CertificateType certificateType = this.determineCertificateType(context);
            certificateQuality.setCertificateType(certificateType);
        }
    }

    private void setTLSourceMsg(CertificateQualityResult certificateQuality, QualityContext context) {
        List messages = certificateQuality.getMessages();
        TLType tlType = context.getTrustedListType();
        String serviceTypeIdentifier = context.getServiceTypeIdentifier();
        if (TLType.OFFICIAL.equals((Object)tlType)) {
            if ("http://uri.etsi.org/TrstSvc/Svctype/CA/QC".equals(serviceTypeIdentifier) || "http://uri.etsi.org/TrstSvc/Svctype/NationalRootCA-QC".equals(serviceTypeIdentifier)) {
                messages.add(SVPFactory.createMessageCode((String)"quality_check_QES_AES_QC_EUMS_TL"));
            } else if ("http://uri.etsi.org/TrstSvc/Svctype/CA/PKC".equals(serviceTypeIdentifier)) {
                messages.add(SVPFactory.createMessageCode((String)"quality_check_AES_EUMS_TL"));
            }
        } else if (TLType.GOVERNIKUS.equals((Object)tlType)) {
            messages.add(SVPFactory.createMessageCode((String)"quality_check_AES_GOV_TL"));
        } else if (TLType.CUSTOM.equals((Object)tlType)) {
            messages.add(SVPFactory.createMessageCode((String)"quality_check_AES_CUSTOM_TL"));
        } else {
            messages.add(SVPFactory.createMessageCode((String)"quality_check_DS_NO_TL"));
        }
    }

    private CertificateType determineCertificateType(QualityContext context) {
        if (context.isBeforeEidas()) {
            return CertificateType.SIG;
        }
        List<CertificateType> typesFromQualifiers = context.fromQualifiers();
        if (typesFromQualifiers.size() == 1) {
            return typesFromQualifiers.get(0);
        }
        List<CertificateType> typesFromQcStatements = context.fromQcStatements();
        List<CertificateType> typesFromAdditionalServiceInformations = context.fromAdditionalServiceInformations();
        if (typesFromQualifiers.isEmpty()) {
            if (typesFromAdditionalServiceInformations.size() == 1) {
                return typesFromAdditionalServiceInformations.get(0);
            }
            if (typesFromQcStatements.size() == 1) {
                return typesFromQcStatements.get(0);
            }
        } else {
            if (typesFromQcStatements.size() == 1) {
                return typesFromQcStatements.get(0);
            }
            if (typesFromAdditionalServiceInformations.size() == 1) {
                return typesFromAdditionalServiceInformations.get(0);
            }
        }
        return CertificateType.INDETERMINATE;
    }

    private void check(QualityContext context, CertificateQualityResult result) throws CertificateQualityCheckException {
        this.checkTrustedListType(context);
        this.checkServiceType(context);
        this.checkServiceStatus(context);
        this.checkNotQualifiedPresent(context);
        this.checkMultipleQCForXPresent(context);
        this.checkNoneOfQCStatementAndQcComplianceAndQcpPresent(context);
        this.checkNoQCForXPresent(context);
        result.setQuality(Quality.QC);
        result.setMajor(MajorTotalResult.TOTAL_PASSED);
    }

    private void checkTrustedListType(QualityContext context) throws CertificateQualityCheckException {
        boolean isOverriden;
        if (context.getTrustedListType() == null) {
            if (!this.hasNeitherQcComplianceNorQCPorQCPPlus(context) || !context.getQcStatements().isEmpty()) {
                throw new CertificateQualityCheckException(Quality.DC, MajorTotalResult.TOTAL_PASSED, "quality_check_dc_warning");
            }
            throw new CertificateQualityCheckException(Quality.DC, MajorTotalResult.TOTAL_PASSED, new String[0]);
        }
        boolean bl = isOverriden = context.getServiceTypeIdentifier() != null && context.getServiceTypeIdentifier().equals("http://uri.etsi.org/TrstSvc/Svctype/CA/PKC") && !this.hasNeitherQcComplianceNorQCPorQCPPlus(context);
        if (context.isOfficialTL() && isOverriden) {
            throw new CertificateQualityCheckException(Quality.AC, MajorTotalResult.TOTAL_PASSED, "quality_qc_overriden");
        }
        if (context.isGovTL() || context.isCustomTL()) {
            if (isOverriden) {
                throw new CertificateQualityCheckException(Quality.AC, MajorTotalResult.TOTAL_PASSED, "quality_qc_overriden");
            }
            throw new CertificateQualityCheckException(Quality.AC, MajorTotalResult.TOTAL_PASSED, new String[0]);
        }
    }

    private void checkServiceType(QualityContext context) throws CertificateQualityCheckException {
        if (context.getServiceTypeIdentifier() == null || context.getServiceTypeIdentifier().equals("http://uri.etsi.org/TrstSvc/Svctype/CA/PKC")) {
            throw new CertificateQualityCheckException(Quality.AC, MajorTotalResult.TOTAL_PASSED, new String[0]);
        }
    }

    private void checkServiceStatus(QualityContext context) throws CertificateQualityCheckException {
        if (context.isOfficialTL() && context.getServiceTypeIdentifier().equals("http://uri.etsi.org/TrstSvc/Svctype/CA/QC") && (context.isWithdrawn() || context.beforeEidasAndStatusCeasedOrRevoked())) {
            throw new CertificateQualityCheckException(Quality.QC, MajorTotalResult.TOTAL_FAILED, "quality_check_tl_withdrawn");
        }
    }

    private void checkNotQualifiedPresent(QualityContext context) throws CertificateQualityCheckException {
        if (context.hasNotQualified()) {
            throw new CertificateQualityCheckException(DefaultCertificateQualityProcessor.certificateQuality(context), MajorTotalResult.TOTAL_FAILED, "quality_not_qualified_qualifier");
        }
    }

    private void checkMultipleQCForXPresent(QualityContext context) throws CertificateQualityCheckException {
        if (context.hasQCForLegalPerson() || context.hasMultipleQCForX()) {
            MajorTotalResult result = MajorTotalResult.INDETERMINATE;
            Quality quality = Quality.QC;
            if (!context.isBeforeEidas() && context.hasQCForLegalPerson()) {
                quality = DefaultCertificateQualityProcessor.certificateQuality(context);
                result = MajorTotalResult.TOTAL_FAILED;
            }
            throw new CertificateQualityCheckException(quality, result, "quality_check_contradicting_service_info_from_tl");
        }
    }

    private boolean hasNeitherQcComplianceNorQCPorQCPPlus(QualityContext context) {
        return !context.hasQcCompliance() && context.hasNoQcpOrQcpPlusPolicy();
    }

    private void checkNoneOfQCStatementAndQcComplianceAndQcpPresent(QualityContext context) throws CertificateQualityCheckException {
        if (!context.hasQCStatement() && this.hasNeitherQcComplianceNorQCPorQCPPlus(context)) {
            throw new CertificateQualityCheckException(Quality.INDETERMINATE, MajorTotalResult.TOTAL_FAILED, "quality_check_missing_qualified");
        }
    }

    private void checkNoQCForXPresent(QualityContext context) throws CertificateQualityCheckException {
        if (!context.hasQCForX()) {
            if (context.hasMultipleQcTypes()) {
                this.processMultiQcTypes(context);
            } else if (!context.hasQcType()) {
                this.processNoQcType(context);
            } else if (context.hasOneQcType()) {
                this.processOneQcType(context);
            }
        }
    }

    private static Quality certificateQuality(QualityContext context) {
        String suffix = "AC";
        if (context.getServiceTypeIdentifier() == null || context.getServiceTypeIdentifier().equals("http://uri.etsi.org/TrstSvc/Svctype/CA/QC")) {
            suffix = "QC";
        }
        return Quality.valueOf((String)suffix);
    }

    private void processNoQcType(QualityContext c) throws CertificateQualityCheckException {
        List reducedList = c.getAdditionalServiceInformations().stream().filter(x -> !"http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/RootCA-QC".equals(x)).collect(Collectors.toList());
        if (c.isBeforeEidas()) {
            if (!reducedList.equals(Collections.singletonList("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures")) && !reducedList.isEmpty()) {
                throw new CertificateQualityCheckException(DefaultCertificateQualityProcessor.certificateQuality(c), MajorTotalResult.INDETERMINATE, "quality_check_inconsistencies_before_eidas");
            }
        } else {
            if (reducedList.size() == 1) {
                return;
            }
            if (reducedList.size() > 1) {
                throw new CertificateQualityCheckException(DefaultCertificateQualityProcessor.certificateQuality(c), MajorTotalResult.TOTAL_FAILED, "quality_check_multiple_cert_type");
            }
            if (!c.hasAdditionalServiceInformation() || !c.hasQCStatement()) {
                throw new CertificateQualityCheckException(DefaultCertificateQualityProcessor.certificateQuality(c), MajorTotalResult.TOTAL_FAILED, "quality_check_missing_cert_type_after_eidas_start");
            }
        }
    }

    private void processOneQcType(QualityContext context) throws CertificateQualityCheckException {
        if (context.hasAdditionalServiceInformation() && !this.isQcTypeInASIList(context)) {
            throw new CertificateQualityCheckException(DefaultCertificateQualityProcessor.certificateQuality(context), MajorTotalResult.TOTAL_FAILED, "quality_check_qctype_asi_mismatch");
        }
    }

    private void processMultiQcTypes(QualityContext context) throws CertificateQualityCheckException {
        Quality quality = Quality.INDETERMINATE;
        String validationMessage = "quality_check_contradicting_service_info_from_cert_overlap_cert_type_asi";
        MajorTotalResult major = MajorTotalResult.INDETERMINATE;
        if (!this.isQcTypeInASIList(context)) {
            quality = DefaultCertificateQualityProcessor.certificateQuality(context);
            major = MajorTotalResult.TOTAL_FAILED;
            validationMessage = "quality_check_contradicting_service_info_from_cert_no_overlap_cert_type_asi";
        }
        throw new CertificateQualityCheckException(quality, major, validationMessage);
    }

    private boolean isQcTypeInASIList(QualityContext context) {
        List<CertificateType> fromQcStatements = context.fromQcStatements();
        List<CertificateType> fromAdditionalServiceInformations = context.fromAdditionalServiceInformations();
        fromQcStatements.retainAll(fromAdditionalServiceInformations);
        return !fromQcStatements.isEmpty();
    }

    public static DefaultCertificateQualityProcessor newInstance() {
        return new DefaultCertificateQualityProcessor();
    }
}

