/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality2;

import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.qualifier.Qualifier;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.URIValue;
import de.governikus.csl.uom.validate.CertificateType;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.validation.quality2.impl.QualifierCriteriaFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public class QualityContext {
    private TLType trustedListType;
    private String serviceTypeIdentifier;
    private ServiceStatus serviceStatus;
    private List<String> additionalServiceInformations;
    private List<String> qualifiers;
    private List<String> qcStatements;
    private List<String> policies;
    private boolean beforeEidas;

    public static QualityContext init(QualifierCriteriaFilter qualifierCriteriaFilter, List<QCStatement> statements, List<PolicyInformation> policies, ServiceInformation serviceInformation, ExtendedTLInformation extendedTLInformation, boolean beforeEidas) {
        TLType trustedListType = Optional.ofNullable(extendedTLInformation).map(ExtendedTLInformation::getTslType).map(Enum::name).map(TLType::valueOf).orElse(null);
        String serviceTypeIdentifier = Optional.ofNullable(serviceInformation).map(ServiceInformation::getServiceTypeIdentifier).map(URIValue::getValue).orElse(null);
        ServiceStatus serviceStatus = Optional.ofNullable(serviceInformation).map(ServiceInformation::getServiceStatus).orElse(null);
        List additionalServiceInformations = Optional.ofNullable(serviceInformation).map(ServiceInformation::getAddtionalServiceInformationURIs).orElse(Collections.emptyList()).stream().map(URIValue::getValue).collect(Collectors.toList());
        List qcStatements = Optional.ofNullable(statements).orElse(Collections.emptyList()).stream().map(QualityContext::processQcStatements).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        List certPolicies = Optional.ofNullable(policies).orElse(Collections.emptyList()).stream().map(PolicyInformation::getPolicyIdentifier).map(ASN1ObjectIdentifier::getId).filter(Objects::nonNull).collect(Collectors.toList());
        List qualifiers = Optional.ofNullable(serviceInformation).map(ServiceInformation::getServiceQualifier).orElse(Collections.emptyList()).stream().filter(qualifierCriteriaFilter).map(Qualifier::getQualifiers).flatMap(Collection::stream).map(URIValue::getValue).collect(Collectors.toList());
        return QualityContext.builder().beforeEidas(beforeEidas).trustedListType(trustedListType).serviceTypeIdentifier(serviceTypeIdentifier).serviceStatus(serviceStatus).additionalServiceInformations(additionalServiceInformations).qcStatements(qcStatements).qualifiers(qualifiers).policies(certPolicies).build();
    }

    public boolean hasQCForLegalPerson() {
        return this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForLegalPerson");
    }

    public boolean isOfficialTL() {
        return this.trustedListType == TLType.OFFICIAL;
    }

    public boolean isCustomTL() {
        return this.trustedListType == TLType.CUSTOM;
    }

    public boolean isGovTL() {
        return this.trustedListType == TLType.GOVERNIKUS;
    }

    public boolean isWithdrawn() {
        return this.serviceStatus == ServiceStatus.WITHDRAWN;
    }

    public boolean beforeEidasAndStatusCeasedOrRevoked() {
        return this.beforeEidas && (this.serviceStatus == ServiceStatus.SUPERVISION_CEASED || this.serviceStatus == ServiceStatus.SUPERVISION_REVOKED || this.serviceStatus == ServiceStatus.ACCREDITATION_CEASED || this.serviceStatus == ServiceStatus.ACCREDITATION_REVOKED);
    }

    public boolean hasNoQcpOrQcpPlusPolicy() {
        return !this.hasQcpPlusOrQcpPolicy();
    }

    public boolean hasQcpPlusOrQcpPolicy() {
        return this.hasPolicyQcp() || this.hasPolicyQcpPlus();
    }

    public boolean hasPolicyQcpPlus() {
        return this.collectionContains(this.policies, "0.4.0.1456.1.1");
    }

    public boolean hasPolicyQcp() {
        return this.collectionContains(this.policies, "0.4.0.1456.1.2");
    }

    public boolean hasQcCompliance() {
        return this.collectionContains(this.qcStatements, "0.4.0.1862.1.1");
    }

    public boolean hasQCStatement() {
        return this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCStatement");
    }

    public boolean hasNotQualified() {
        return this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/NotQualified");
    }

    public boolean hasQcStatusAsInCert() {
        return this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert") || this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCSSCDStatusAsInCert");
    }

    public boolean hasQCForX() {
        return this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig") || this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal") || this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA");
    }

    public boolean hasQcType() {
        return this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.1") || this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.2") || this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.3");
    }

    public boolean hasAdditionalServiceInformation() {
        return this.collectionContains(this.additionalServiceInformations, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures") || this.collectionContains(this.additionalServiceInformations, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals") || this.collectionContains(this.additionalServiceInformations, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication");
    }

    public boolean hasMultipleQCForX() {
        int i = 0;
        if (this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig")) {
            ++i;
        }
        if (this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal")) {
            ++i;
        }
        if (this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA")) {
            ++i;
        }
        return i > 1;
    }

    public int qcTypesCount() {
        int i = 0;
        if (this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.1")) {
            ++i;
        }
        if (this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.2")) {
            ++i;
        }
        if (this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.3")) {
            ++i;
        }
        return i;
    }

    public boolean hasMultipleQcTypes() {
        return this.qcTypesCount() > 1;
    }

    public boolean hasOneQcType() {
        return this.qcTypesCount() == 1;
    }

    public boolean illegalSigGQualifierCombination() {
        return this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD") || this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCSSCDStatusAsInCert") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD") || this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCSSCDStatusAsInCert") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD");
    }

    public boolean asInCertOrNoSigGIndication() {
        return this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCSSCDStatusAsInCert") || !this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD") && !this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD");
    }

    public boolean illegalEidasQualifierCombination() {
        return this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD") || this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD") || this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD") || this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD") || this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert") && this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf");
    }

    public boolean asInCertOrNoEidasIndication() {
        return this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDStatusAsInCert") || !this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD") && !this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf") && !this.qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD");
    }

    public List<CertificateType> fromQcStatements() {
        ArrayList<CertificateType> types = new ArrayList<CertificateType>();
        if (this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.1")) {
            types.add(CertificateType.SIG);
        }
        if (this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.2")) {
            types.add(CertificateType.SEAL);
        }
        if (this.collectionContains(this.qcStatements, "0.4.0.1862.1.6.3")) {
            types.add(CertificateType.WSA);
        }
        return types;
    }

    public List<CertificateType> fromAdditionalServiceInformations() {
        ArrayList<CertificateType> types = new ArrayList<CertificateType>();
        if (this.collectionContains(this.additionalServiceInformations, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures")) {
            types.add(CertificateType.SIG);
        }
        if (this.collectionContains(this.additionalServiceInformations, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals")) {
            types.add(CertificateType.SEAL);
        }
        if (this.collectionContains(this.additionalServiceInformations, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForWebSiteAuthentication")) {
            types.add(CertificateType.WSA);
        }
        return types;
    }

    public List<CertificateType> fromQualifiers() {
        ArrayList<CertificateType> types = new ArrayList<CertificateType>();
        if (this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESig")) {
            types.add(CertificateType.SIG);
        }
        if (this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForESeal")) {
            types.add(CertificateType.SEAL);
        }
        if (this.collectionContains(this.qualifiers, "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCForWSA")) {
            types.add(CertificateType.WSA);
        }
        return types;
    }

    private boolean collectionContains(Collection<?> collection, Object o) {
        if (collection == null) {
            return false;
        }
        return collection.contains(o);
    }

    private static List<String> processQcStatements(QCStatement qcStatement) {
        ArrayList<String> qcStatements = new ArrayList<String>();
        if (ETSIQCObjectIdentifiers.id_etsi_qcs_QcType.equals((ASN1Primitive)qcStatement.getStatementId())) {
            ASN1Sequence statementInfo = (ASN1Sequence)qcStatement.getStatementInfo();
            for (ASN1Encodable encodable : statementInfo) {
                qcStatements.add(((ASN1ObjectIdentifier)encodable).getId());
            }
        } else {
            qcStatements.add(qcStatement.getStatementId().getId());
        }
        return qcStatements;
    }

    @Generated
    private static boolean $default$beforeEidas() {
        return false;
    }

    @Generated
    public static QualityContextBuilder builder() {
        return new QualityContextBuilder();
    }

    @Generated
    public TLType getTrustedListType() {
        return this.trustedListType;
    }

    @Generated
    public String getServiceTypeIdentifier() {
        return this.serviceTypeIdentifier;
    }

    @Generated
    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    @Generated
    public List<String> getAdditionalServiceInformations() {
        return this.additionalServiceInformations;
    }

    @Generated
    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    @Generated
    public List<String> getQcStatements() {
        return this.qcStatements;
    }

    @Generated
    public List<String> getPolicies() {
        return this.policies;
    }

    @Generated
    public boolean isBeforeEidas() {
        return this.beforeEidas;
    }

    @Generated
    public void setTrustedListType(TLType trustedListType) {
        this.trustedListType = trustedListType;
    }

    @Generated
    public void setServiceTypeIdentifier(String serviceTypeIdentifier) {
        this.serviceTypeIdentifier = serviceTypeIdentifier;
    }

    @Generated
    public void setServiceStatus(ServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    @Generated
    public void setAdditionalServiceInformations(List<String> additionalServiceInformations) {
        this.additionalServiceInformations = additionalServiceInformations;
    }

    @Generated
    public void setQualifiers(List<String> qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Generated
    public void setQcStatements(List<String> qcStatements) {
        this.qcStatements = qcStatements;
    }

    @Generated
    public void setPolicies(List<String> policies) {
        this.policies = policies;
    }

    @Generated
    public void setBeforeEidas(boolean beforeEidas) {
        this.beforeEidas = beforeEidas;
    }

    @Generated
    public QualityContext(TLType trustedListType, String serviceTypeIdentifier, ServiceStatus serviceStatus, List<String> additionalServiceInformations, List<String> qualifiers, List<String> qcStatements, List<String> policies, boolean beforeEidas) {
        this.trustedListType = trustedListType;
        this.serviceTypeIdentifier = serviceTypeIdentifier;
        this.serviceStatus = serviceStatus;
        this.additionalServiceInformations = additionalServiceInformations;
        this.qualifiers = qualifiers;
        this.qcStatements = qcStatements;
        this.policies = policies;
        this.beforeEidas = beforeEidas;
    }

    @Generated
    public QualityContext() {
        this.beforeEidas = QualityContext.$default$beforeEidas();
    }

    @Generated
    public static class QualityContextBuilder {
        @Generated
        private TLType trustedListType;
        @Generated
        private String serviceTypeIdentifier;
        @Generated
        private ServiceStatus serviceStatus;
        @Generated
        private ArrayList<String> additionalServiceInformations;
        @Generated
        private ArrayList<String> qualifiers;
        @Generated
        private ArrayList<String> qcStatements;
        @Generated
        private ArrayList<String> policies;
        @Generated
        private boolean beforeEidas$set;
        @Generated
        private boolean beforeEidas$value;

        @Generated
        QualityContextBuilder() {
        }

        @Generated
        public QualityContextBuilder trustedListType(TLType trustedListType) {
            this.trustedListType = trustedListType;
            return this;
        }

        @Generated
        public QualityContextBuilder serviceTypeIdentifier(String serviceTypeIdentifier) {
            this.serviceTypeIdentifier = serviceTypeIdentifier;
            return this;
        }

        @Generated
        public QualityContextBuilder serviceStatus(ServiceStatus serviceStatus) {
            this.serviceStatus = serviceStatus;
            return this;
        }

        @Generated
        public QualityContextBuilder additionalServiceInformation(String additionalServiceInformation) {
            if (this.additionalServiceInformations == null) {
                this.additionalServiceInformations = new ArrayList();
            }
            this.additionalServiceInformations.add(additionalServiceInformation);
            return this;
        }

        @Generated
        public QualityContextBuilder additionalServiceInformations(Collection<? extends String> additionalServiceInformations) {
            if (additionalServiceInformations != null) {
                if (this.additionalServiceInformations == null) {
                    this.additionalServiceInformations = new ArrayList();
                }
                this.additionalServiceInformations.addAll(additionalServiceInformations);
            }
            return this;
        }

        @Generated
        public QualityContextBuilder clearAdditionalServiceInformations() {
            if (this.additionalServiceInformations != null) {
                this.additionalServiceInformations.clear();
            }
            return this;
        }

        @Generated
        public QualityContextBuilder qualifier(String qualifier) {
            if (this.qualifiers == null) {
                this.qualifiers = new ArrayList();
            }
            this.qualifiers.add(qualifier);
            return this;
        }

        @Generated
        public QualityContextBuilder qualifiers(Collection<? extends String> qualifiers) {
            if (qualifiers != null) {
                if (this.qualifiers == null) {
                    this.qualifiers = new ArrayList();
                }
                this.qualifiers.addAll(qualifiers);
            }
            return this;
        }

        @Generated
        public QualityContextBuilder clearQualifiers() {
            if (this.qualifiers != null) {
                this.qualifiers.clear();
            }
            return this;
        }

        @Generated
        public QualityContextBuilder qcStatement(String qcStatement) {
            if (this.qcStatements == null) {
                this.qcStatements = new ArrayList();
            }
            this.qcStatements.add(qcStatement);
            return this;
        }

        @Generated
        public QualityContextBuilder qcStatements(Collection<? extends String> qcStatements) {
            if (qcStatements != null) {
                if (this.qcStatements == null) {
                    this.qcStatements = new ArrayList();
                }
                this.qcStatements.addAll(qcStatements);
            }
            return this;
        }

        @Generated
        public QualityContextBuilder clearQcStatements() {
            if (this.qcStatements != null) {
                this.qcStatements.clear();
            }
            return this;
        }

        @Generated
        public QualityContextBuilder policy(String policy) {
            if (this.policies == null) {
                this.policies = new ArrayList();
            }
            this.policies.add(policy);
            return this;
        }

        @Generated
        public QualityContextBuilder policies(Collection<? extends String> policies) {
            if (policies != null) {
                if (this.policies == null) {
                    this.policies = new ArrayList();
                }
                this.policies.addAll(policies);
            }
            return this;
        }

        @Generated
        public QualityContextBuilder clearPolicies() {
            if (this.policies != null) {
                this.policies.clear();
            }
            return this;
        }

        @Generated
        public QualityContextBuilder beforeEidas(boolean beforeEidas) {
            this.beforeEidas$value = beforeEidas;
            this.beforeEidas$set = true;
            return this;
        }

        @Generated
        public QualityContext build() {
            List<String> policies;
            List<String> qcStatements;
            List<String> qualifiers;
            List<String> additionalServiceInformations;
            switch (this.additionalServiceInformations == null ? 0 : this.additionalServiceInformations.size()) {
                case 0: {
                    additionalServiceInformations = Collections.emptyList();
                    break;
                }
                case 1: {
                    additionalServiceInformations = Collections.singletonList(this.additionalServiceInformations.get(0));
                    break;
                }
                default: {
                    additionalServiceInformations = Collections.unmodifiableList(new ArrayList<String>(this.additionalServiceInformations));
                }
            }
            switch (this.qualifiers == null ? 0 : this.qualifiers.size()) {
                case 0: {
                    qualifiers = Collections.emptyList();
                    break;
                }
                case 1: {
                    qualifiers = Collections.singletonList(this.qualifiers.get(0));
                    break;
                }
                default: {
                    qualifiers = Collections.unmodifiableList(new ArrayList<String>(this.qualifiers));
                }
            }
            switch (this.qcStatements == null ? 0 : this.qcStatements.size()) {
                case 0: {
                    qcStatements = Collections.emptyList();
                    break;
                }
                case 1: {
                    qcStatements = Collections.singletonList(this.qcStatements.get(0));
                    break;
                }
                default: {
                    qcStatements = Collections.unmodifiableList(new ArrayList<String>(this.qcStatements));
                }
            }
            switch (this.policies == null ? 0 : this.policies.size()) {
                case 0: {
                    policies = Collections.emptyList();
                    break;
                }
                case 1: {
                    policies = Collections.singletonList(this.policies.get(0));
                    break;
                }
                default: {
                    policies = Collections.unmodifiableList(new ArrayList<String>(this.policies));
                }
            }
            boolean beforeEidas$value = this.beforeEidas$value;
            if (!this.beforeEidas$set) {
                beforeEidas$value = QualityContext.$default$beforeEidas();
            }
            return new QualityContext(this.trustedListType, this.serviceTypeIdentifier, this.serviceStatus, additionalServiceInformations, qualifiers, qcStatements, policies, beforeEidas$value);
        }

        @Generated
        public String toString() {
            return "QualityContext.QualityContextBuilder(trustedListType=" + this.trustedListType + ", serviceTypeIdentifier=" + this.serviceTypeIdentifier + ", serviceStatus=" + this.serviceStatus + ", additionalServiceInformations=" + this.additionalServiceInformations + ", qualifiers=" + this.qualifiers + ", qcStatements=" + this.qcStatements + ", policies=" + this.policies + ", beforeEidas$value=" + this.beforeEidas$value + ")";
        }
    }
}

