/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.tsl.uris.ServiceQualifier;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import java.util.List;

public class QualifierCheck {
    private boolean notQualified;
    private boolean qcStatement;
    private boolean forLegalPerson;
    private boolean forESig;
    private boolean forESeal;
    private boolean forWSA;
    private boolean qcNoSSCD;
    private boolean qcWithSSCD;
    private boolean qcSSCDAsInCert;
    private boolean qcNoQSCD;
    private boolean qcWithQSCD;
    private boolean qcQSCDAsInCert;
    private boolean qcQSCDManagedOnBehalf;
    private EUQualifiedCertificateType certificateType;
    private List<ServiceQualifier> qualifier;

    public QualifierCheck(List<ServiceQualifier> qualifier, EUQualifiedCertificateType certificateType) {
        this.qualifier = qualifier;
        this.certificateType = certificateType;
        if (qualifier != null) {
            for (ServiceQualifier q : qualifier) {
                if (q == ServiceQualifier.NOT_QUALIFIED) {
                    this.notQualified = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_STATEMENT) {
                    this.qcStatement = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_FOR_LEGAL_PERSON) {
                    this.forLegalPerson = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_FOR_E_SIG) {
                    this.forESig = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_FOR_E_SEAL) {
                    this.forESeal = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_FOR_WSA) {
                    this.forWSA = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_NO_SSCD) {
                    this.qcNoSSCD = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_WITH_SSCD) {
                    this.qcWithSSCD = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_SSCD_STATUS_AS_IN_CERT) {
                    this.qcSSCDAsInCert = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_NO_QSCD) {
                    this.qcNoQSCD = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_WITH_QSCD) {
                    this.qcWithQSCD = true;
                    continue;
                }
                if (q == ServiceQualifier.QC_QSCD_STATUS_AS_IN_CERT) {
                    this.qcQSCDAsInCert = true;
                    continue;
                }
                if (q != ServiceQualifier.QC_QSCD_MANAGED_ON_BEHALF) continue;
                this.qcQSCDManagedOnBehalf = true;
            }
        }
    }

    public boolean hasIllegalAdESQCCombination() {
        return this.notQualified && this.qcStatement || this.forLegalPerson && this.forESig || this.forESeal && this.forESig || this.forWSA && this.forESig || this.forESeal && this.forWSA;
    }

    public boolean hasIllegalQCCombination() {
        return this.qcNoSSCD && this.qcWithSSCD || this.qcWithSSCD && this.qcSSCDAsInCert || this.qcNoSSCD && this.qcSSCDAsInCert || this.qcWithQSCD && this.qcNoQSCD || this.qcWithQSCD && this.qcQSCDAsInCert || this.qcNoQSCD && this.qcQSCDAsInCert || this.qcQSCDManagedOnBehalf && this.qcNoQSCD || this.qcQSCDManagedOnBehalf && this.qcQSCDAsInCert;
    }

    public boolean hasNotQualified() {
        return this.notQualified;
    }

    public boolean hasNoQcForX() {
        return !this.forESeal && !this.forESig && !this.forWSA;
    }

    public boolean hasMultipleQcForX() {
        return this.forESeal && this.forESig || this.forESeal && this.forWSA || this.forWSA && this.forESig;
    }

    public boolean hasQcForX() {
        return this.forESeal || this.forWSA || this.forESig;
    }

    public boolean hasConflictingCertTypeQualifier() {
        switch (this.certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                return this.forLegalPerson || this.forESeal || this.forWSA;
            }
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                return this.forESig || this.forWSA;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                return this.forESig || this.forESeal;
            }
        }
        return true;
    }

    public boolean hasQCAndCorrectType() {
        boolean b = false;
        switch (this.certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                b = this.forESig;
                break;
            }
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                b = this.forESeal;
                break;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                b = this.forWSA;
            }
        }
        return this.qcStatement && b;
    }

    public boolean hasQCStatement() {
        return this.qcStatement;
    }

    public boolean hasQCNoQSCD() {
        return this.qcNoQSCD;
    }

    public boolean hasQCNoSSCD() {
        return this.qcNoSSCD;
    }

    public boolean hasQCWithQSCD() {
        return this.qcWithQSCD;
    }

    public boolean hasQCWithSSCD() {
        return this.qcWithSSCD;
    }

    public List<ServiceQualifier> getQualifier() {
        return this.qualifier;
    }
}

