/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.validation.quality.InternalVariableSet;
import de.governikus.csl.validation.quality.QCTypeSigCert;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class InternalVariableSetInitializer {
    private static final Date EIDAS_START;

    public InternalVariableSet initializeInternalVariables(X509CertificateBaseFacade<?> cert, Date referenceDate) {
        InternalVariableSet result = new InternalVariableSet();
        result.certificateType = cert.getEUQualifiedCertificateType();
        if (result.certificateType == null) {
            result.certificateType = EUQualifiedCertificateType.CERTIFICATE_FOR_ELECTRONIC_SIGNATURES;
        }
        result.sigCert = cert;
        result.qcTypeSigCert = this.initializeQCTypeSigCert(cert);
        result.tRef = result.tSig = referenceDate;
        result.QSCD = cert.hasQCSSCDStatement();
        if (cert.getNotBefore().before(EIDAS_START) && cert.hasQCPSSCDPolicy()) {
            result.QSCD = true;
        }
        result.tRefBeforeEIDAS = result.tRef.compareTo(EIDAS_START) < 0;
        return result;
    }

    private QCTypeSigCert initializeQCTypeSigCert(X509CertificateBaseFacade<?> cert) {
        boolean qcComplianceStatement = cert.hasQCComplianceStatement();
        EUQualifiedCertificateType euQualifiedCertificateType = null;
        List euQualifiedCertificateTypes = cert.getEUQualifiedCertificateTypes();
        if (!euQualifiedCertificateTypes.isEmpty()) {
            euQualifiedCertificateType = (EUQualifiedCertificateType)euQualifiedCertificateTypes.get(0);
        }
        if (qcComplianceStatement) {
            if (euQualifiedCertificateTypes.size() > 1) {
                return QCTypeSigCert.INC;
            }
            if (euQualifiedCertificateType == null || euQualifiedCertificateType == EUQualifiedCertificateType.CERTIFICATE_FOR_ELECTRONIC_SIGNATURES) {
                return QCTypeSigCert.QCeSig;
            }
            if (euQualifiedCertificateType != null && euQualifiedCertificateType == EUQualifiedCertificateType.CERTIFICATE_FOR_ELECTRONIC_SEALS) {
                return QCTypeSigCert.QCeSeal;
            }
            if (euQualifiedCertificateType != null && euQualifiedCertificateType == EUQualifiedCertificateType.CERTIFICATE_FOR_WEBSITE_AUTHENTICATION) {
                return QCTypeSigCert.QWAC;
            }
        } else {
            if (cert.getNotBefore().before(EIDAS_START) && (cert.hasQCPPolicy() || cert.hasQCPSSCDPolicy())) {
                return QCTypeSigCert.QCeSig;
            }
            if (euQualifiedCertificateType != null && euQualifiedCertificateType == EUQualifiedCertificateType.CERTIFICATE_FOR_ELECTRONIC_SIGNATURES) {
                return QCTypeSigCert.Type1;
            }
            if (euQualifiedCertificateType != null && euQualifiedCertificateType == EUQualifiedCertificateType.CERTIFICATE_FOR_ELECTRONIC_SEALS) {
                return QCTypeSigCert.Type2;
            }
            if (euQualifiedCertificateType != null && euQualifiedCertificateType == EUQualifiedCertificateType.CERTIFICATE_FOR_WEBSITE_AUTHENTICATION) {
                return QCTypeSigCert.Type3;
            }
        }
        return QCTypeSigCert.Void;
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2016, 6, 1);
        EIDAS_START = gregorianCalendar.getTime();
    }
}

