/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.AdditionalServiceInformation;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.validate.svp.InternationalizedString;
import de.governikus.csl.validate.svp.TSPInfo;
import de.governikus.csl.validation.quality.ETSIQualifiedCertPath;
import de.governikus.csl.validation.quality.InternalVariableSet;
import de.governikus.csl.validation.quality.SingleCertChainCheckResult;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class ETSIQualifiedCertPathAnalyzer {
    private boolean tRefBeforeEIDAS;
    private EUQualifiedCertificateType certificateType;
    private X509CertificateBaseFacade<?> sigCert;

    public ETSIQualifiedCertPathAnalyzer(boolean tRefBeforeEIDAS, EUQualifiedCertificateType certificateType, X509CertificateImpl sigCert) {
        this.tRefBeforeEIDAS = tRefBeforeEIDAS;
        this.certificateType = certificateType;
        this.sigCert = sigCert;
    }

    public ETSIQualifiedCertPathAnalyzer(InternalVariableSet variables) {
        this.tRefBeforeEIDAS = variables.tRefBeforeEIDAS;
        this.certificateType = variables.certificateType;
        this.sigCert = variables.sigCert;
    }

    public ETSIQualifiedCertPath checkCertPathForEUMS(BaseCertificateSignature<?> eeCertificate, Deque<X509Data> caCertificates) {
        SingleCertChainCheckResult evaluationResult = this.checkCertForEUMS(eeCertificate);
        if (evaluationResult == SingleCertChainCheckResult.OK) {
            return new ETSIQualifiedCertPath(evaluationResult, eeCertificate);
        }
        X509Data bestCert = eeCertificate;
        SingleCertChainCheckResult bestResult = evaluationResult;
        if (caCertificates != null) {
            Iterator<X509Data> iterator = caCertificates.descendingIterator();
            while (iterator.hasNext()) {
                X509Data ca = iterator.next();
                evaluationResult = this.checkCertForEUMS(ca);
                if (evaluationResult == SingleCertChainCheckResult.OK) {
                    return new ETSIQualifiedCertPath(evaluationResult, ca);
                }
                if (evaluationResult.compareTo(bestResult) <= 0) continue;
                bestResult = evaluationResult;
                bestCert = ca;
            }
        }
        return new ETSIQualifiedCertPath(bestResult, bestCert);
    }

    public SingleCertChainCheckResult checkCertForEUMS(BaseCertificateSignature<?> cert) {
        TSPInfo tspInformation;
        List addtionalServiceInformationURIs;
        ExtendedTLInformation tslInformation = cert.getTslInformation();
        if (tslInformation == null) {
            return SingleCertChainCheckResult.NOT_IN_EU_MS_TL;
        }
        if (tslInformation.getTslType() != TLType.OFFICIAL) {
            return SingleCertChainCheckResult.NOT_IN_EU_MS_TL;
        }
        List reliabilityConcerns = Optional.ofNullable(tslInformation.getReliabilityConcerns()).orElse(Collections.emptyList());
        if (reliabilityConcerns.contains("tl_invalid_signature")) {
            return SingleCertChainCheckResult.INVALID_EU_MS_TL;
        }
        if (reliabilityConcerns.contains("tl_expired")) {
            return SingleCertChainCheckResult.EXPIRED_EU_MS_TL;
        }
        ServiceInformation serviceInformation = cert.getServiceInformation();
        if (serviceInformation == null) {
            return SingleCertChainCheckResult.NOT_IN_EU_MS_TL;
        }
        ServiceType serviceTypeIdentifier = serviceInformation.getServiceTypeIdentifier();
        if (serviceTypeIdentifier == null || serviceTypeIdentifier != ServiceType.CA_QC) {
            return SingleCertChainCheckResult.NO_CA_QC;
        }
        if (!this.tRefBeforeEIDAS && (addtionalServiceInformationURIs = serviceInformation.getAddtionalServiceInformationURIs()) != null && !addtionalServiceInformationURIs.contains(this.getExpectedAddtionalServiceInformationCertType())) {
            return SingleCertChainCheckResult.NO_CA_QC;
        }
        LDAPEntry entry = new LDAPEntry(this.sigCert.getIssuerX500Principal());
        String organisation = entry.getOrganisation();
        if (organisation != null && ((tspInformation = serviceInformation.getTspInformation()) == null || !this.isInList(organisation, tspInformation.getNames()) && !this.isInList(organisation, tspInformation.getTradeNames()))) {
            return SingleCertChainCheckResult.ISSUER_NAME_DO_NOT_MATCH;
        }
        return SingleCertChainCheckResult.OK;
    }

    private AdditionalServiceInformation getExpectedAddtionalServiceInformationCertType() {
        switch (this.certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                return AdditionalServiceInformation.E_SIG;
            }
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                return AdditionalServiceInformation.E_SEAL;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                return AdditionalServiceInformation.WSA;
            }
        }
        return AdditionalServiceInformation.E_SIG;
    }

    private boolean isInList(String organisation, List<InternationalizedString> names) {
        if (names == null) {
            return false;
        }
        for (InternationalizedString is : names) {
            String value = is.getValue();
            if (value == null || !value.equals(organisation)) continue;
            return true;
        }
        return false;
    }
}

