/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.tsl.uris.ServiceQualifier;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validation.quality.BaseQualificationAnalyzer;
import de.governikus.csl.validation.quality.ETSIQualifiedCertPath;
import de.governikus.csl.validation.quality.ETSIQualifiedCertPathAnalyzer;
import de.governikus.csl.validation.quality.InternalVariableSet;
import de.governikus.csl.validation.quality.InternalVariableSetInitializer;
import de.governikus.csl.validation.quality.QualificationProcessorFactory;
import de.governikus.csl.validation.quality.QualifierCheck;
import de.governikus.csl.validation.quality.SingleCertChainCheckResult;
import de.governikus.csl.validation.quality.TLQualifierProcessor;
import de.governikus.csl.validation.quality2.QualityProcessor;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.List;

public class ETSIQualificationProcessor
implements QualityProcessor<CertificateQualificationInformation> {
    private QualificationProcessorFactory factory;

    public ETSIQualificationProcessor() {
        this.factory = new QualificationProcessorFactory();
    }

    public ETSIQualificationProcessor(QualificationProcessorFactory factory) {
        this.factory = factory;
    }

    private ClaimedQuality determineClaimedQuality(BaseCertificateSignature<?> eeCertificate, ETSIQualifiedCertPath isInEUMSTrustedList, QualifierCheck qualifierCheck, InternalVariableSet internalVariables) {
        boolean tlClaimsQSCD;
        Object cert = eeCertificate.getCert();
        boolean certClaimsQC = cert.hasQCComplianceStatement();
        boolean tlClaimsQC = isInEUMSTrustedList.checkResult == SingleCertChainCheckResult.OK || isInEUMSTrustedList.checkResult == SingleCertChainCheckResult.ISSUER_NAME_DO_NOT_MATCH;
        boolean bl = tlClaimsQSCD = qualifierCheck.hasQCWithQSCD() || qualifierCheck.hasQCWithSSCD();
        if (certClaimsQC || tlClaimsQC) {
            if (internalVariables.QSCD || tlClaimsQSCD || internalVariables.certificateType == EUQualifiedCertificateType.CERTIFICATE_FOR_WEBSITE_AUTHENTICATION) {
                return ClaimedQuality.QC;
            }
            return ClaimedQuality.ADV_QC;
        }
        return ClaimedQuality.ADV;
    }

    @Override
    public CertificateQualificationInformation process(BaseCertificateSignature<?> eeCertificate, Deque<X509Data> caCertificates, Date referenceDate) {
        List<ServiceQualifier> qualifier;
        Object eeCertImpl = eeCertificate.getCert();
        InternalVariableSetInitializer initializer = this.factory.createInternalVariableSetInitializer();
        InternalVariableSet internalVariables = initializer.initializeInternalVariables((X509CertificateBaseFacade<?>)eeCertImpl, referenceDate);
        ETSIQualifiedCertPathAnalyzer pathAnalyzer = this.factory.createCertPathAnalyzer(internalVariables);
        ETSIQualifiedCertPath isInEUMSTrustedList = pathAnalyzer.checkCertPathForEUMS(eeCertificate, caCertificates);
        BaseCertificateSignature<?> service = isInEUMSTrustedList.bestCert;
        if (eeCertificate instanceof X509Data) {
            TLQualifierProcessor qualifierProcessor = this.factory.createTLQualifierProcessor();
            qualifier = qualifierProcessor.processQualifier(service.getServiceInformation(), (X509Certificate)internalVariables.sigCert);
        } else {
            qualifier = new ArrayList<ServiceQualifier>();
        }
        QualifierCheck qualifierCheck = this.factory.createQualifierCheck(qualifier, internalVariables.certificateType);
        ClaimedQuality claimedQuality = this.determineClaimedQuality(eeCertificate, isInEUMSTrustedList, qualifierCheck, internalVariables);
        BaseQualificationAnalyzer analyzer = null;
        switch (claimedQuality) {
            case ADV: {
                analyzer = this.factory.createAdESQualifyingAnalyzer(internalVariables);
                break;
            }
            case ADV_QC: {
                analyzer = this.factory.createAdESQCQualifyingAnalyzer(internalVariables);
                break;
            }
            default: {
                analyzer = this.factory.createQESQualifyingAnalyzer(internalVariables);
            }
        }
        CertificateQualificationInformation qualificationInformation = analyzer.checkQuality(eeCertificate, isInEUMSTrustedList, qualifierCheck, caCertificates);
        eeCertificate.setQualityInformation(qualificationInformation);
        return qualificationInformation;
    }

    private static enum ClaimedQuality {
        ADV,
        ADV_QC,
        QC;

    }
}

