/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.CertificateLevel;
import de.governikus.csl.uom.validate.CertificateQualification;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validation.quality.ETSIAdESQCAnalyzer;
import de.governikus.csl.validation.quality.ETSIQualifiedCertPath;
import de.governikus.csl.validation.quality.InternalVariableSet;
import de.governikus.csl.validation.quality.QualifierCheck;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Deque;

public class ETSIQESAnalyzer
extends ETSIAdESQCAnalyzer {
    public ETSIQESAnalyzer(InternalVariableSet variables, CertificateQualification notApplicableType) {
        super(variables, notApplicableType);
    }

    @Override
    public CertificateQualificationInformation checkQuality(BaseCertificateSignature<?> eeCertificate, ETSIQualifiedCertPath isInEUMSTrustedList, QualifierCheck qualifierCheck, Deque<X509Data> caCertificates) {
        CertificateQualificationInformation result = super.checkQuality(eeCertificate, isInEUMSTrustedList, qualifierCheck, caCertificates);
        if (result.getCertificateQualification() == this.notApplicableType) {
            return result;
        }
        if (result.getCertificateQualification() == CertificateQualification.ADS) {
            return result;
        }
        if (qualifierCheck.hasIllegalQCCombination()) {
            result.setCertificateQualification(this.notApplicableType);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_illegal_qualifying_extensions_qc"));
            CertificateLevel certificateLevel = this.determineQCCertificateLevel(eeCertificate, result, qualifierCheck);
            result.setCertificateLevel(certificateLevel);
            return result;
        }
        if (qualifierCheck.hasQCNoQSCD() || this.variables.tRefBeforeEIDAS && qualifierCheck.hasQCNoSSCD()) {
            result.setCertificateQualification(this.notApplicableType);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_no_qscd_qualifier"));
            CertificateLevel certificateLevel = this.determineQCCertificateLevel(eeCertificate, result, qualifierCheck);
            result.setCertificateLevel(certificateLevel);
            return result;
        }
        if (qualifierCheck.hasQCWithQSCD() || this.variables.tRefBeforeEIDAS && qualifierCheck.hasQCWithSSCD()) {
            result.setCertificateQualification(CertificateQualification.QES_EUMS_TL);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_qc"));
            CertificateLevel certificateLevel = this.determineQCCertificateLevel(eeCertificate, result, qualifierCheck);
            result.setCertificateLevel(certificateLevel);
            return result;
        }
        if (this.variables.QSCD) {
            result.setCertificateQualification(CertificateQualification.QES_EUMS_TL);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_qc"));
            CertificateLevel certificateLevel = this.determineQCCertificateLevel(eeCertificate, result, qualifierCheck);
            result.setCertificateLevel(certificateLevel);
            return result;
        }
        result.setCertificateQualification(this.notApplicableType);
        result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_no_qscd_qualifier"));
        CertificateLevel certificateLevel = this.determineQCCertificateLevel(eeCertificate, result, qualifierCheck);
        result.setCertificateLevel(certificateLevel);
        return result;
    }

    private CertificateLevel determineQCCertificateLevel(BaseCertificateSignature<?> cert, CertificateQualificationInformation result, QualifierCheck qualifierCheck) {
        EUQualifiedCertificateType certificateType = result.getCertificateType();
        switch (certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                if (qualifierCheck.hasQCStatement() && this.hasMessageCode((ValidationMessageCode)result.getCertificateQualificationMsgCode())) {
                    return CertificateLevel.NO_QC_EUMS_TL_SEAL;
                }
                if (!this.hasCAQC(cert)) break;
                return CertificateLevel.QC_EUMS_TL_SEAL;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                if (qualifierCheck.hasQCStatement() && this.hasMessageCode((ValidationMessageCode)result.getCertificateQualificationMsgCode())) {
                    return CertificateLevel.NO_QC_EUMS_TL_WSA;
                }
                if (!this.hasCAQC(cert)) break;
                return CertificateLevel.QC_EUMS_TL_WSA;
            }
            default: {
                if (qualifierCheck.hasQCStatement() && this.hasMessageCode((ValidationMessageCode)result.getCertificateQualificationMsgCode())) {
                    return CertificateLevel.NO_QC_EUMS_TL_SIG;
                }
                if (!this.hasCAQC(cert)) break;
                return CertificateLevel.QC_EUMS_TL_SIG;
            }
        }
        return this.determineQESNotApplicableLevel(certificateType);
    }

    private CertificateLevel determineQESNotApplicableLevel(EUQualifiedCertificateType type) {
        switch (this.notApplicableType) {
            case NO_QES_EUMS_TL: {
                switch (type) {
                    case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                        return CertificateLevel.NO_QC_EUMS_TL_SEAL;
                    }
                    case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                        return CertificateLevel.NO_QC_EUMS_TL_WSA;
                    }
                }
                return CertificateLevel.NO_QC_EUMS_TL_SIG;
            }
            case NO_AES_QC_EUMS_TL: {
                switch (type) {
                    case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                        return CertificateLevel.NO_AC_EUMS_TL_SEAL;
                    }
                    case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                        return CertificateLevel.NO_AC_EUMS_TL_WSA;
                    }
                }
                return CertificateLevel.NO_AC_EUMS_TL_SIG;
            }
        }
        return CertificateLevel.DC_SIG;
    }
}

