/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.validate.CertificateLevel;
import de.governikus.csl.uom.validate.CertificateQualification;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validation.quality.BaseQualificationAnalyzer;
import de.governikus.csl.validation.quality.ETSIQualifiedCertPath;
import de.governikus.csl.validation.quality.InternalVariableSet;
import de.governikus.csl.validation.quality.QCTypeSigCert;
import de.governikus.csl.validation.quality.QualifierCheck;
import de.governikus.csl.validation.quality.SingleCertChainCheckResult;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;

public class ETSIAdESQCAnalyzer
extends BaseQualificationAnalyzer {
    private List<String> invalidMessages = Arrays.asList("quality_illegal_qualifying_extensions_ades_qc", "quality_illegal_qualifying_extensions_qc", "quality_inconsistent_cert_type", "quality_no_eums_tl_entry", "quality_not_qualified_qualifier", "quality_service_status_not_granted_qes", "quality_service_status_not_granted_aes", "quality_no_tl_entry");
    protected CertificateQualification notApplicableType;

    public ETSIAdESQCAnalyzer(InternalVariableSet variables, CertificateQualification notApplicableType) {
        super(variables);
        this.notApplicableType = notApplicableType;
    }

    @Override
    public CertificateQualificationInformation checkQuality(BaseCertificateSignature<?> eeCertificate, ETSIQualifiedCertPath isInEUMSTrustedList, QualifierCheck qualifierCheck, Deque<X509Data> caCertificates) {
        CertificateQualificationInformation result = super.checkQuality(eeCertificate, isInEUMSTrustedList, qualifierCheck, caCertificates);
        BaseCertificateSignature<?> service = isInEUMSTrustedList.bestCert;
        SingleCertChainCheckResult checkResult = isInEUMSTrustedList.checkResult;
        switch (checkResult) {
            case ISSUER_NAME_DO_NOT_MATCH: {
                result.getCertificateQualificationWarning().add(SVPFactory.createMessageCode((String)"quality_issuer_name_mismatch"));
                break;
            }
            case INVALID_EU_MS_TL: {
                result.setCertificateQualification(CertificateQualification.ADS);
                result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"tl_invalid_signature"));
                return result;
            }
            case EXPIRED_EU_MS_TL: {
                result.setCertificateQualification(CertificateQualification.ADS);
                result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"tl_expired"));
                return result;
            }
            case NOT_IN_EU_MS_TL: 
            case NO_CA_QC: {
                result.setCertificateQualification(this.notApplicableType);
                result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_no_eums_tl_entry"));
                CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
                result.setCertificateLevel(adesQcCertificateLevel);
                return result;
            }
        }
        if (!this.checkServiceStatus(service, this.variables)) {
            result.setCertificateQualification(this.notApplicableType);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_service_status_not_granted_qes"));
            CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
            result.setCertificateLevel(adesQcCertificateLevel);
            return result;
        }
        if (qualifierCheck.hasIllegalAdESQCCombination()) {
            result.setCertificateQualification(this.notApplicableType);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_illegal_qualifying_extensions_ades_qc"));
            CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
            result.setCertificateLevel(adesQcCertificateLevel);
            return result;
        }
        if (qualifierCheck.hasNotQualified()) {
            result.setCertificateQualification(this.notApplicableType);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_not_qualified_qualifier"));
            CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
            result.setCertificateLevel(adesQcCertificateLevel);
            return result;
        }
        if (qualifierCheck.hasConflictingCertTypeQualifier()) {
            result.setCertificateQualification(this.notApplicableType);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_inconsistent_cert_type"));
            CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
            result.setCertificateLevel(adesQcCertificateLevel);
            return result;
        }
        if (qualifierCheck.hasQCAndCorrectType()) {
            result.setCertificateQualification(CertificateQualification.AES_QC_EUMS_TL);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_ades_qc"));
            CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
            result.setCertificateLevel(adesQcCertificateLevel);
            return result;
        }
        if (qualifierCheck.hasQCStatement() && this.qcTypeSigCertMatchesExpectation()) {
            result.setCertificateQualification(CertificateQualification.AES_QC_EUMS_TL);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_ades_qc"));
            CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
            result.setCertificateLevel(adesQcCertificateLevel);
            return result;
        }
        if (this.qcTypeSigCertMatchesCertificateType()) {
            result.setCertificateQualification(CertificateQualification.AES_QC_EUMS_TL);
            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_ades_qc"));
            CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
            result.setCertificateLevel(adesQcCertificateLevel);
            return result;
        }
        result.setCertificateQualification(this.notApplicableType);
        result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_inconsistent_cert_type"));
        CertificateLevel adesQcCertificateLevel = this.determineAdESQCCertificateLevel(service, result, qualifierCheck);
        result.setCertificateLevel(adesQcCertificateLevel);
        return result;
    }

    private boolean checkServiceStatus(BaseCertificateSignature<?> service, InternalVariableSet internalVariables) {
        ServiceStatus serviceStatus = service.getServiceInformation().getServiceStatus();
        if (!internalVariables.tRefBeforeEIDAS) {
            return serviceStatus == ServiceStatus.GRANTED;
        }
        return serviceStatus == ServiceStatus.UNDER_SUPERVISION || serviceStatus == ServiceStatus.SUPERVISION_IN_CESSATION || serviceStatus == ServiceStatus.ACCREDITED;
    }

    private boolean qcTypeSigCertMatchesCertificateType() {
        switch (this.variables.certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                return this.variables.qcTypeSigCert == QCTypeSigCert.QCeSig;
            }
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                return this.variables.qcTypeSigCert == QCTypeSigCert.QCeSeal;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                return this.variables.qcTypeSigCert == QCTypeSigCert.QWAC;
            }
        }
        return false;
    }

    private boolean qcTypeSigCertMatchesExpectation() {
        switch (this.variables.certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                return this.variables.qcTypeSigCert == QCTypeSigCert.Type1 || this.variables.qcTypeSigCert == QCTypeSigCert.QCeSig;
            }
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                return this.variables.qcTypeSigCert == QCTypeSigCert.Type2 || this.variables.qcTypeSigCert == QCTypeSigCert.QCeSeal;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                return this.variables.qcTypeSigCert == QCTypeSigCert.Type3 || this.variables.qcTypeSigCert == QCTypeSigCert.QWAC;
            }
        }
        return false;
    }

    private CertificateLevel determineAdESQCCertificateLevel(BaseCertificateSignature<?> cert, CertificateQualificationInformation result, QualifierCheck qualifierCheck) {
        EUQualifiedCertificateType certificateType = result.getCertificateType();
        switch (certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                if (this.hasMessageCode((ValidationMessageCode)result.getCertificateQualificationMsgCode())) {
                    return CertificateLevel.NO_QC_EUMS_TL_SEAL;
                }
                if (!this.checkServiceStatus(cert, this.variables)) break;
                return CertificateLevel.QC_EUMS_TL_SEAL;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                if (this.hasMessageCode((ValidationMessageCode)result.getCertificateQualificationMsgCode())) {
                    return CertificateLevel.NO_QC_EUMS_TL_WSA;
                }
                if (!this.checkServiceStatus(cert, this.variables)) break;
                return CertificateLevel.QC_EUMS_TL_WSA;
            }
            default: {
                if (this.hasMessageCode((ValidationMessageCode)result.getCertificateQualificationMsgCode())) {
                    return CertificateLevel.NO_QC_EUMS_TL_SIG;
                }
                if (!this.checkServiceStatus(cert, this.variables)) break;
                return CertificateLevel.QC_EUMS_TL_SIG;
            }
        }
        return this.determineAdesQcNotApplicableLevel(certificateType);
    }

    private CertificateLevel determineAdesQcNotApplicableLevel(EUQualifiedCertificateType type) {
        switch (this.notApplicableType) {
            case NO_QES_EUMS_TL: 
            case NO_AES_QC_EUMS_TL: {
                switch (type) {
                    case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                        return CertificateLevel.NO_QC_EUMS_TL_SEAL;
                    }
                    case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                        return CertificateLevel.NO_QC_EUMS_TL_WSA;
                    }
                }
                return CertificateLevel.NO_QC_EUMS_TL_SIG;
            }
        }
        switch (type) {
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                return CertificateLevel.NO_AC_EUMS_TL_SEAL;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                return CertificateLevel.NO_AC_EUMS_TL_WSA;
            }
        }
        return CertificateLevel.NO_AC_EUMS_TL_SIG;
    }

    protected boolean hasCAQC(BaseCertificateSignature<?> cert) {
        ServiceInformation serviceInformation = cert.getServiceInformation();
        if (serviceInformation == null) {
            serviceInformation = cert.getIssuerServiceInformation();
        }
        if (serviceInformation != null) {
            return serviceInformation.getServiceTypeIdentifier() == ServiceType.CA_QC;
        }
        return false;
    }

    protected boolean hasMessageCode(ValidationMessageCode msg) {
        String messageCode = msg.getMessageCode();
        return this.invalidMessages.contains(messageCode);
    }
}

