/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.AdditionalServiceInformation;
import de.governikus.csl.tsl.uris.ServiceQualifier;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.CertificateLevel;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validation.quality.ETSIQualifiedCertPath;
import de.governikus.csl.validation.quality.InternalVariableSet;
import de.governikus.csl.validation.quality.QualifierCheck;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.Deque;
import java.util.List;

public class BaseQualificationAnalyzer {
    private static final int[][] CERTIFICATE_TYPE_DETERMINATION_MATRIX = new int[][]{{1, 1, 2, 3}, {1, 1, 1, 1}, {2, 2, 2, 2}, {3, 3, 3, 3}, {1, 1, 1, 1}, {2, 2, 2, 2}, {3, 3, 3, 3}};
    protected InternalVariableSet variables;

    public BaseQualificationAnalyzer(InternalVariableSet variables) {
        this.variables = variables;
    }

    protected CertificateQualificationInformation initResult(BaseCertificateSignature<?> service, QualifierCheck qualifierCheck) {
        List<ServiceQualifier> qualifier;
        CertificateQualificationInformation result = new CertificateQualificationInformation();
        ServiceInformation serviceInformation = service.getServiceInformation();
        List additionalServiceInformationURIs = null;
        if (serviceInformation != null && (additionalServiceInformationURIs = serviceInformation.getAddtionalServiceInformationURIs()) != null) {
            List additionalServiceInformation = result.getAdditionalServiceInformation();
            for (AdditionalServiceInformation additionalInfo : additionalServiceInformationURIs) {
                additionalServiceInformation.add(additionalInfo.getValue());
            }
        }
        if ((qualifier = qualifierCheck.getQualifier()) != null) {
            for (ServiceQualifier sq : qualifier) {
                result.getTlQualifier().add(sq.getValue());
            }
        }
        EUQualifiedCertificateType realCertificateType = this.determineCertificateType(this.variables.sigCert, qualifier, additionalServiceInformationURIs);
        result.setCertificateType(realCertificateType);
        CertificateLevel baseCertificateLevel = this.determineBaseCertificateLevel(result);
        result.setCertificateLevel(baseCertificateLevel);
        return result;
    }

    private EUQualifiedCertificateType determineCertificateType(X509CertificateBaseFacade<?> cert, List<ServiceQualifier> serviceQualifier, List<AdditionalServiceInformation> additionalServiceInformation) {
        EUQualifiedCertificateType euQualifiedCertificateType = cert.getEUQualifiedCertificateType();
        int colIndex = 0;
        if (euQualifiedCertificateType != null) {
            switch (euQualifiedCertificateType) {
                case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                    colIndex = 1;
                    break;
                }
                case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                    colIndex = 2;
                    break;
                }
                case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                    colIndex = 3;
                }
            }
        }
        int rowIndex = 0;
        rowIndex = this.getTypeIndex(serviceQualifier, additionalServiceInformation);
        if (rowIndex < 0) {
            rowIndex = colIndex;
        }
        int type = CERTIFICATE_TYPE_DETERMINATION_MATRIX[rowIndex][colIndex];
        switch (type) {
            case 1: {
                return EUQualifiedCertificateType.CERTIFICATE_FOR_ELECTRONIC_SIGNATURES;
            }
            case 2: {
                return EUQualifiedCertificateType.CERTIFICATE_FOR_ELECTRONIC_SEALS;
            }
            case 3: {
                return EUQualifiedCertificateType.CERTIFICATE_FOR_WEBSITE_AUTHENTICATION;
            }
        }
        throw new RuntimeException("Undefined certificate type");
    }

    private int getTypeIndex(List<ServiceQualifier> serviceQualifier, List<AdditionalServiceInformation> additionalServiceInformation) {
        int rowIndex = 0;
        if (serviceQualifier != null) {
            for (ServiceQualifier qualifier : serviceQualifier) {
                if (qualifier == ServiceQualifier.QC_FOR_E_SEAL) {
                    return 2;
                }
                if (qualifier == ServiceQualifier.QC_FOR_E_SIG) {
                    return 1;
                }
                if (qualifier != ServiceQualifier.QC_FOR_WSA) continue;
                return 3;
            }
        }
        if (additionalServiceInformation != null) {
            int changeCtr = 0;
            for (AdditionalServiceInformation additionalInfo : additionalServiceInformation) {
                if (additionalInfo == AdditionalServiceInformation.E_SIG) {
                    rowIndex = 4;
                    ++changeCtr;
                    continue;
                }
                if (additionalInfo == AdditionalServiceInformation.E_SEAL) {
                    rowIndex = 5;
                    ++changeCtr;
                    continue;
                }
                if (additionalInfo != AdditionalServiceInformation.WSA) continue;
                rowIndex = 6;
                ++changeCtr;
            }
            if (changeCtr > 1) {
                rowIndex = -1;
            }
        }
        return rowIndex;
    }

    protected CertificateLevel determineBaseCertificateLevel(CertificateQualificationInformation result) {
        EUQualifiedCertificateType certificateType = result.getCertificateType();
        switch (certificateType) {
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                return CertificateLevel.DC_SEAL;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                return CertificateLevel.DC_WSA;
            }
        }
        return CertificateLevel.DC_SIG;
    }

    public CertificateQualificationInformation checkQuality(BaseCertificateSignature<?> eeCertificate, ETSIQualifiedCertPath isInEUMSTrustedList, QualifierCheck qualifierCheck, Deque<X509Data> caCertificates) {
        return this.initResult(isInEUMSTrustedList.bestCert, qualifierCheck);
    }
}

