/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.quality;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.validate.CertificateLevel;
import de.governikus.csl.uom.validate.CertificateQualification;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validation.quality.BaseQualificationAnalyzer;
import de.governikus.csl.validation.quality.ETSIQualifiedCertPath;
import de.governikus.csl.validation.quality.InternalVariableSet;
import de.governikus.csl.validation.quality.QualifierCheck;
import de.governikus.csl.validation.x509.BaseCertificateSignature;
import de.governikus.csl.validation.x509.X509Data;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public class AdESQualificationAnalyzer
extends BaseQualificationAnalyzer {
    public AdESQualificationAnalyzer(InternalVariableSet variables) {
        super(variables);
    }

    @Override
    public CertificateQualificationInformation checkQuality(BaseCertificateSignature<?> eeCertificate, ETSIQualifiedCertPath isInEUMSTrustedList, QualifierCheck qualifierCheck, Deque<X509Data> caCertificates) {
        CertificateQualificationInformation result = super.checkQuality(eeCertificate, isInEUMSTrustedList, qualifierCheck, caCertificates);
        ArrayList certChain = new ArrayList();
        certChain.add(eeCertificate);
        if (caCertificates != null && !caCertificates.isEmpty()) {
            certChain.addAll(caCertificates);
        }
        for (BaseCertificateSignature baseCertificateSignature : certChain) {
            ServiceInformation serviceInformation = baseCertificateSignature.getServiceInformation();
            ExtendedTLInformation tslInformation = baseCertificateSignature.getTslInformation();
            if (tslInformation == null && serviceInformation == null) continue;
            List reliabilityConcerns = Optional.ofNullable(tslInformation).map(ExtendedTLInformation::getReliabilityConcerns).orElse(Collections.emptyList());
            if (reliabilityConcerns.contains("tl_invalid_signature")) {
                result.setCertificateQualification(CertificateQualification.ADS);
                result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"tl_invalid_signature"));
                return result;
            }
            if (reliabilityConcerns.contains("tl_expired")) {
                result.setCertificateQualification(CertificateQualification.ADS);
                result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"tl_expired"));
                return result;
            }
            boolean isURIPKC = false;
            boolean isGranted = false;
            if (serviceInformation != null) {
                if (serviceInformation.getServiceTypeIdentifier() != null) {
                    boolean bl = isURIPKC = serviceInformation.getServiceTypeIdentifier() == ServiceType.CA_PKC;
                }
                if (serviceInformation.getServiceStatus() != null) {
                    isGranted = serviceInformation.getServiceStatus() == ServiceStatus.GRANTED;
                }
            }
            TLType tlType = tslInformation != null ? tslInformation.getTslType() : null;
            CertificateLevel advancedCertificateLevel = null;
            if (isURIPKC) {
                if (tlType != null) {
                    switch (tlType) {
                        case OFFICIAL: {
                            if (isGranted) {
                                result.setCertificateQualification(CertificateQualification.AES_EUMS_TL);
                                advancedCertificateLevel = this.determineAdvancedCertificateLevel(result, tlType, isGranted);
                                result.setCertificateLevel(advancedCertificateLevel);
                                break;
                            }
                            result.setCertificateQualification(CertificateQualification.NO_AES_EUMS_TL);
                            result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_service_status_not_granted_aes"));
                            advancedCertificateLevel = this.determineAdvancedCertificateLevel(result, tlType, isGranted);
                            result.setCertificateLevel(advancedCertificateLevel);
                            break;
                        }
                        case GOVERNIKUS: {
                            result.setCertificateQualification(CertificateQualification.AES_GOV_TL);
                            advancedCertificateLevel = this.determineAdvancedCertificateLevel(result, tlType, true);
                            result.setCertificateLevel(advancedCertificateLevel);
                            break;
                        }
                        case CUSTOM: {
                            result.setCertificateQualification(CertificateQualification.AES_CUSTOM_TL);
                            advancedCertificateLevel = this.determineAdvancedCertificateLevel(result, tlType, true);
                            result.setCertificateLevel(advancedCertificateLevel);
                        }
                    }
                } else {
                    result.setCertificateQualification(CertificateQualification.ADS);
                    result.setCertificateQualificationMsgCode(SVPFactory.createMessageCode((String)"quality_no_tl_entry"));
                }
            } else {
                result.setCertificateQualification(CertificateQualification.ADS);
            }
            return result;
        }
        result.setCertificateQualification(CertificateQualification.ADS);
        return result;
    }

    private CertificateLevel determineAdvancedCertificateLevel(CertificateQualificationInformation result, TLType tlType, boolean isAdvanced) {
        EUQualifiedCertificateType certificateType = result.getCertificateType();
        switch (tlType) {
            case GOVERNIKUS: {
                switch (certificateType) {
                    case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                        return CertificateLevel.AC_GOV_TL_SEAL;
                    }
                    case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                        return CertificateLevel.AC_GOV_TL_WSA;
                    }
                }
                return CertificateLevel.AC_GOV_TL_SIG;
            }
            case CUSTOM: {
                switch (certificateType) {
                    case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                        return CertificateLevel.AC_CUSTOM_TL_SEAL;
                    }
                    case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                        return CertificateLevel.AC_CUSTOM_TL_WSA;
                    }
                }
                return CertificateLevel.AC_CUSTOM_TL_SIG;
            }
            case OFFICIAL: {
                switch (certificateType) {
                    case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                        if (isAdvanced) {
                            return CertificateLevel.AC_EUMS_TL_SEAL;
                        }
                        return CertificateLevel.NO_AC_EUMS_TL_SEAL;
                    }
                    case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                        if (isAdvanced) {
                            return CertificateLevel.AC_EUMS_TL_WSA;
                        }
                        return CertificateLevel.NO_AC_EUMS_TL_WSA;
                    }
                }
                if (isAdvanced) {
                    return CertificateLevel.AC_EUMS_TL_SIG;
                }
                return CertificateLevel.NO_AC_EUMS_TL_SIG;
            }
        }
        return this.determineBaseCertificateLevel(result);
    }
}

