/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.validate.svp.EvaluatedPolicyEntry;
import de.governikus.csl.validation.policy.AbstractPolicyReferenceManager;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.policy.PolicyEvaluator;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.function.Function;

public class EvaluatingPolicyReferenceManager
extends AbstractPolicyReferenceManager<EvaluatedPolicyEntry, EvaluatedValidationPolicyType> {
    private PolicyEvaluator evaluator;
    private PolicyProviderManager policyProviderManager;

    public EvaluatingPolicyReferenceManager(PolicyProviderManager policyProviderManager) {
        this.policyProviderManager = policyProviderManager;
        this.evaluator = new PolicyEvaluator(policyProviderManager);
    }

    public PolicyProviderManager getPolicyProviderManager() {
        return this.policyProviderManager;
    }

    private EvaluatedValidationPolicyType evaluatePolicy(ValidationPolicyType policy, PolicyOrigin origin) {
        return this.evaluator.createEvaluatedPolicy(policy, origin, true);
    }

    public int addPolicy(ValidationPolicyType policy, PolicyOrigin origin) {
        return this.addPolicy(policy, (ValidationPolicyType p) -> this.createInstance(++this.ctr, policy, origin));
    }

    public int addPolicy(EvaluatedValidationPolicyType policy) {
        Function<ValidationPolicyType, EvaluatedPolicyEntry> f = x -> SVPFactory.createPolicyEntry((int)(++this.ctr), (EvaluatedValidationPolicyType)policy);
        return this.addPolicy(policy.getPolicy(), f);
    }

    private EvaluatedPolicyEntry createInstance(int i, ValidationPolicyType policy, PolicyOrigin origin) {
        return SVPFactory.createPolicyEntry((int)i, (EvaluatedValidationPolicyType)this.evaluatePolicy(policy, origin));
    }

    @Override
    protected EvaluatedPolicyEntry createInstance(int i, ValidationPolicyType policy) {
        return SVPFactory.createPolicyEntry((int)i, (EvaluatedValidationPolicyType)this.evaluatePolicy(policy, null));
    }

    @Override
    protected EvaluatedValidationPolicyType getPolicy(EvaluatedPolicyEntry instance) {
        return instance.getPolicy();
    }

    @Override
    protected int getID(EvaluatedPolicyEntry instance) {
        return instance.getId();
    }
}

