/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.validation.policy.PolicyEvaluatorKey;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class AbstractPolicyReferenceManager<T, P> {
    protected int ctr = 0;
    protected Map<PolicyEvaluatorKey, T> entries;

    AbstractPolicyReferenceManager() {
    }

    public int addPolicy(ValidationPolicyType policy) {
        return this.addPolicy(policy, p -> this.createInstance(++this.ctr, policy));
    }

    protected int addPolicy(ValidationPolicyType policy, Function<ValidationPolicyType, T> f) {
        PolicyEvaluatorKey key = new PolicyEvaluatorKey(policy);
        if (this.entries != null) {
            T policyEntry = this.entries.get(key);
            if (policyEntry != null) {
                return this.getID(policyEntry);
            }
            policyEntry = f.apply(policy);
            this.entries.put(key, policyEntry);
            return this.getID(policyEntry);
        }
        this.entries = new HashMap<PolicyEvaluatorKey, T>();
        this.entries.put(key, f.apply(policy));
        return this.ctr;
    }

    protected abstract T createInstance(int var1, ValidationPolicyType var2);

    public List<T> getPolicyEntries() {
        if (this.entries != null) {
            return this.entries.values().stream().collect(Collectors.toList());
        }
        return null;
    }

    public Map<Integer, P> getPolicyMappingAsMap() {
        if (this.entries != null) {
            return this.entries.values().stream().collect(Collectors.toMap(this::getID, this::getPolicy));
        }
        return null;
    }

    public Optional<T> getPolicyById(int id) {
        if (this.entries != null) {
            return this.entries.values().stream().filter(x -> this.getID(x) == id).findFirst();
        }
        return Optional.empty();
    }

    protected abstract P getPolicy(T var1);

    protected abstract int getID(T var1);
}

