/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.utils.DigestUtil;
import de.governikus.csl.validation.er.ReducedHashTreeValidationResponse;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReducedHashTreeValidator {
    private static final int MASK = 255;

    public ReducedHashTreeValidationResponse validate(List<List<byte[]>> reducedHashTree, DigestAlgorithm digestAlgorithm, byte[] ... hashValues) {
        if (reducedHashTree.isEmpty()) {
            return new ReducedHashTreeValidationResponse(null, false);
        }
        boolean first = true;
        boolean valid = true;
        byte[] hash = null;
        for (List<byte[]> partialTree : reducedHashTree) {
            if (first) {
                for (byte[] hashValue : hashValues) {
                    valid &= this.isHashInPartialTree(hashValue, partialTree);
                }
                first = false;
            }
            hash = this.createBinaryAscendingHashOfPartialTree(partialTree, hash, digestAlgorithm);
        }
        return new ReducedHashTreeValidationResponse(hash, valid);
    }

    private byte[] createBinaryAscendingHashOfPartialTree(List<byte[]> binaryPartialTree, byte[] lastHash, DigestAlgorithm digestAlgorithm) {
        if (binaryPartialTree.size() == 1 && lastHash == null) {
            return binaryPartialTree.get(0);
        }
        ArrayList<byte[]> data = new ArrayList<byte[]>(binaryPartialTree);
        if (lastHash != null) {
            data.add(lastHash);
        }
        Collections.sort(data, this::compareUnsigned);
        return DigestUtil.createHash(data, (DigestAlgorithm)digestAlgorithm);
    }

    private int compareUnsigned(byte[] a, byte[] b) {
        int minLength = Integer.min(a.length, b.length);
        for (int i = 0; i < minLength; ++i) {
            if (a[i] == b[i]) continue;
            return (a[i] & 0xFF) < (b[i] & 0xFF) ? -1 : 1;
        }
        return a.length - b.length;
    }

    private boolean isHashInPartialTree(byte[] hashToFind, List<byte[]> binaryPartialTree) {
        for (byte[] os : binaryPartialTree) {
            if (!MessageDigest.isEqual(hashToFind, os)) continue;
            return true;
        }
        return false;
    }
}

