/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogManager;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogResponse;
import de.governikus.csl.algorithm_catalog.UnsupportedCatalogNameException;
import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.DigestAlgorithmValidityInformation;
import de.governikus.csl.validate.svp.ERHashTreeValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.Date;

public class ReducedHashTreeDigestAlgorithmValidator {
    private AlgorithmCatalogManager algorithmCatalogManager;

    public ReducedHashTreeDigestAlgorithmValidator(AlgorithmCatalogManager algorithmCatalogManager) {
        this.algorithmCatalogManager = algorithmCatalogManager;
    }

    public void validateDigestAlgorithm(DigestAlgorithm digestAlgorithm, ValidationPolicyType policy, ERHashTreeValidationResult hashTreeResult, Date date) {
        DigestAlgorithmValidityInformation digestAlgorithmValidationResult = new DigestAlgorithmValidityInformation();
        hashTreeResult.setDigestAlgorithmValidationResult(digestAlgorithmValidationResult);
        digestAlgorithmValidationResult.setDigestAlgorithm(SVPFactory.createDigestAlgorithm((DigestAlgorithm)digestAlgorithm));
        AlgorithmCatalogResponse algorithmValidity = null;
        try {
            String name = policy.getAlgorithmCatalog().name();
            AlgorithmCatalog catalog = this.algorithmCatalogManager.getAlgorithmCatalog(name);
            hashTreeResult.setAlgorithmCatalogInformation(catalog.getCatalogMetaData());
            algorithmValidity = this.algorithmCatalogManager.getAlgorithmValidity(name, digestAlgorithm, Usage.VERIFY_TIMESTAMP_SIGNATURE);
        }
        catch (UnsupportedCatalogNameException e) {
            digestAlgorithmValidationResult.setValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"no_algorithm_catalog_configured"}));
            return;
        }
        digestAlgorithmValidationResult.setValidationResult(this.createResult((ValidatePolicy)policy, algorithmValidity, date));
        digestAlgorithmValidationResult.setAlgorithmExpirationDate(algorithmValidity.getExpirationDate());
    }

    private ValidationResult createResult(ValidatePolicy policy, AlgorithmCatalogResponse resp, Date dateToCompare) {
        ValidationResult vr = SVPFactory.createResultOk();
        boolean withoutExpirationDate = resp.isWithoutExpirationDate();
        Date expirationDate = resp.getExpirationDate();
        if (dateToCompare == null || !withoutExpirationDate && expirationDate.compareTo(dateToCompare) < 0) {
            if (policy.isInvalidateOldAlgorithms().booleanValue()) {
                vr.setMajor(MajorTotalResult.TOTAL_FAILED);
                vr.setMinor(MinorResult.CRYPTO_CONSTRAINTS_FAILURE);
            } else {
                vr.setMajor(MajorTotalResult.INDETERMINATE);
                vr.setMinor(MinorResult.CRYPTO_CONSTRAINTS_FAILURE_NO_POE);
            }
        }
        return vr;
    }
}

