/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.utils.DigestUtil;
import de.governikus.csl.validate.svp.ERArchiveTimestampChainValidationResult;
import de.governikus.csl.validate.svp.EvidenceRecordValidationResult;
import de.governikus.csl.validation.er.ArchiveTimestamp;
import de.governikus.csl.validation.er.ArchiveTimestampChain;
import de.governikus.csl.validation.er.ArchiveTimestampChainValidator;
import de.governikus.csl.validation.er.EvidenceRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceRecordValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvidenceRecordValidator.class);
    private ArchiveTimestampChainValidator chainValidator;

    public EvidenceRecordValidator(ArchiveTimestampChainValidator chainValidator) {
        this.chainValidator = chainValidator;
    }

    public EvidenceRecordValidationResult validate(EvidenceRecord evidenceRecord, Date validAt) {
        List<StreamProvider> contentData = evidenceRecord.getExpectedSecuredData();
        return this.validate(evidenceRecord.getArchiveTimeStampSequence(), validAt, contentData);
    }

    public EvidenceRecordValidationResult validate(List<ArchiveTimestampChain> archiveTimestampSequence, Date validAt, List<? extends StreamProvider> data) {
        int numChains = archiveTimestampSequence.size();
        EvidenceRecordValidationResult res = new EvidenceRecordValidationResult();
        List chainResults = res.getTimestampChainResponses();
        ArchiveTimestampChain lastChain = null;
        for (int i = 0; i < numChains; ++i) {
            int j;
            Date validationDate = validAt;
            if (i < numChains - 1) {
                validationDate = archiveTimestampSequence.get(i + 1).getTimestamps().get(0).getTimestamp().getGenerationTime();
            }
            ArchiveTimestampChain archiveTimestampChain = archiveTimestampSequence.get(i);
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm(archiveTimestampChain);
            Object hashesToValidate = null;
            if (lastChain == null) {
                hashesToValidate = new byte[data.size()][];
                for (j = 0; j < data.size(); ++j) {
                    hashesToValidate[j] = DigestUtil.createHashQuietly((StreamProvider)data.get(j), (DigestAlgorithm)digestAlgorithm);
                }
            } else {
                hashesToValidate = new byte[data.size()][];
                for (j = 0; j < data.size(); ++j) {
                    hashesToValidate[j] = this.hash(data.get(j), archiveTimestampSequence, i, digestAlgorithm);
                }
            }
            ERArchiveTimestampChainValidationResult chanValidationResult = this.chainValidator.validate(archiveTimestampChain, validationDate, (byte[][])hashesToValidate);
            chainResults.add(chanValidationResult);
            lastChain = archiveTimestampChain;
        }
        return res;
    }

    private DigestAlgorithm getDigestAlgorithm(ArchiveTimestampChain archiveTimestampChain) {
        ArchiveTimestamp archiveTimestamp = archiveTimestampChain.getTimestamps().get(0);
        DigestAlgorithm digestAlgorithm = archiveTimestamp.getDigestAlgorithm();
        if (digestAlgorithm != null) {
            return digestAlgorithm;
        }
        return archiveTimestamp.getTimestamp().getMessageImprintHashAlgorithm();
    }

    private byte[] hash(StreamProvider dataObject, List<ArchiveTimestampChain> archiveTimestampSequence, int until, DigestAlgorithm digestAlgorithm) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(DigestUtil.createHashQuietly((StreamProvider)dataObject, (DigestAlgorithm)digestAlgorithm));
        ASN1EncodableVector atss = new ASN1EncodableVector();
        for (int i = 0; i < until; ++i) {
            ArchiveTimestampChain chain = archiveTimestampSequence.get(i);
            try (ASN1InputStream stream = new ASN1InputStream(chain.getRawData());){
                atss.add((ASN1Encodable)stream.readObject());
                continue;
            }
            catch (IOException e) {
                LOGGER.info("Can't create ASN1 stream", (Throwable)e);
            }
        }
        try {
            data.add(DigestUtil.createHash((byte[])new DERSequence(atss).getEncoded(), (DigestAlgorithm)digestAlgorithm));
            return DigestUtil.createHash(data, (DigestAlgorithm)digestAlgorithm);
        }
        catch (IOException e) {
            LOGGER.info("Can't create ASN1 sequence for archive timestamp validation", (Throwable)e);
            return new byte[0];
        }
    }
}

