/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.ERArchiveTimestampChainValidationResult;
import de.governikus.csl.validate.svp.ERArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.ERHashTreeValidationResult;
import de.governikus.csl.validate.svp.EvidenceRecordValidationResult;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EvidenceRecordResultUtil {
    private EvidenceRecordResultUtil() {
    }

    public static List<TypedDate> getPOEsFromEvidenceRecordValidationResult(EvidenceRecordValidationResult er) {
        List timestampChainResponses = er.getTimestampChainResponses();
        ArrayList<TypedDate> result = new ArrayList<TypedDate>();
        for (ERArchiveTimestampChainValidationResult chainResp : timestampChainResponses) {
            EvidenceRecordResultUtil.addPOEsFromTimestampChain(chainResp, result);
        }
        return result;
    }

    private static void addPOEsFromTimestampChain(ERArchiveTimestampChainValidationResult chainResp, List<TypedDate> result) {
        boolean first = true;
        for (ERArchiveTimestampValidationResult erTimestamp : chainResp.getTimestampResponses()) {
            TimestampValidationResult timestampTokenValidationResult;
            if (first) {
                if (!EvidenceRecordResultUtil.hasValidHashTree(erTimestamp)) {
                    return;
                }
                first = false;
            }
            if ((timestampTokenValidationResult = erTimestamp.getTimestampTokenValidationResult()).getOverallResult(true).getMajor() != MajorTotalResult.TOTAL_PASSED) continue;
            TimestampQuality timestampQuality = timestampTokenValidationResult.getTimestampQuality();
            result.add(SVPFactory.createTypedDate((Date)timestampTokenValidationResult.getGenerationTime(), (DateType)DateType.fromTimestampQuality((TimestampQuality)timestampQuality)));
        }
    }

    private static boolean hasValidHashTree(ERArchiveTimestampValidationResult timestamp) {
        ERHashTreeValidationResult hashTreeValidationResult = timestamp.getHashTreeValidationResult();
        return hashTreeValidationResult != null && hashTreeValidationResult.isDataCovered() && hashTreeValidationResult.getDigestAlgorithmValidationResult().getValidationResult().getMajor() == MajorTotalResult.TOTAL_PASSED;
    }
}

