/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.governikus.csl.validation.er.EvidenceRecordFilterResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;

public class EvidenceRecordFilter {
    private List<byte[]> internalEvidenceRecords;
    private List<byte[]> externalEvidenceRecords;
    private byte[] cmsSignature;
    private int filterFrom;
    private int toSkip;

    public EvidenceRecordFilter(byte[] cmsSignature, int filterFrom) {
        this.cmsSignature = cmsSignature;
        this.filterFrom = filterFrom;
    }

    public EvidenceRecordFilterResult filterEvidenceRecords() throws CMSException, IOException {
        this.toSkip = this.filterFrom;
        this.internalEvidenceRecords = new ArrayList<byte[]>();
        this.externalEvidenceRecords = new ArrayList<byte[]>();
        ContentInfo ci = ContentInfo.getInstance((Object)this.cmsSignature);
        ContentInfo ciNew = this.filterContentInfo(ci);
        return new EvidenceRecordFilterResult(ciNew.getEncoded(), this.internalEvidenceRecords, this.externalEvidenceRecords);
    }

    private ContentInfo filterContentInfo(ContentInfo ci) throws CMSException, IOException {
        try {
            SignedData sd = SignedData.getInstance((Object)ci.getContent());
            return new ContentInfo(new ASN1ObjectIdentifier("1.2.840.113549.1.7.2"), (ASN1Encodable)this.filterSignedData(sd));
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", (Exception)e);
        }
    }

    private SignedData filterSignedData(SignedData sd) throws IOException {
        return new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), sd.getCertificates(), sd.getCRLs(), this.filterSignerInfos(sd.getSignerInfos()));
    }

    private ASN1Set filterSignerInfos(ASN1Set signerInfos) throws IOException {
        int size = signerInfos.size();
        ASN1Encodable[] newSignerInfos = new ASN1Encodable[size];
        for (int i = 0; i < size; ++i) {
            ASN1Encodable signerInfo = signerInfos.getObjectAt(i);
            newSignerInfos[i] = this.filterSignerInfo(SignerInfo.getInstance((Object)signerInfo));
        }
        return new DERSet(newSignerInfos);
    }

    private ASN1Encodable filterSignerInfo(SignerInfo instance) throws IOException {
        return new SignerInfo(instance.getSID(), instance.getDigestAlgorithm(), instance.getAuthenticatedAttributes(), instance.getDigestEncryptionAlgorithm(), instance.getEncryptedDigest(), this.filterUnsignedAttributes(instance.getUnauthenticatedAttributes()));
    }

    private ASN1Set filterUnsignedAttributes(ASN1Set unsignedAttributes) throws IOException {
        int size = unsignedAttributes.size();
        ArrayList<Attribute> newUnsignedAttributes = new ArrayList<Attribute>();
        for (int i = 0; i < size; ++i) {
            ASN1Encodable unsignedAttribute = unsignedAttributes.getObjectAt(i);
            Attribute instance = Attribute.getInstance((Object)unsignedAttribute);
            String oid = instance.getAttrType().getId();
            Attribute attributeToAdd = instance;
            if (oid.equals("1.2.840.113549.1.9.16.2.49")) {
                if (this.internalEvidenceRecords == null) {
                    this.internalEvidenceRecords = new ArrayList<byte[]>();
                }
                attributeToAdd = this.filterAttribute(instance, this.internalEvidenceRecords, "1.2.840.113549.1.9.16.2.49");
            } else if (oid.equals("1.2.840.113549.1.9.16.2.50")) {
                if (this.externalEvidenceRecords == null) {
                    this.externalEvidenceRecords = new ArrayList<byte[]>();
                }
                attributeToAdd = this.filterAttribute(instance, this.externalEvidenceRecords, "1.2.840.113549.1.9.16.2.50");
            }
            if (attributeToAdd == null) continue;
            newUnsignedAttributes.add(attributeToAdd);
        }
        if (newUnsignedAttributes.isEmpty()) {
            return null;
        }
        return new DERSet(newUnsignedAttributes.toArray(new ASN1Encodable[size]));
    }

    private Attribute filterAttribute(Attribute instance, List<byte[]> erList, String attributeIdentifier) throws IOException {
        ASN1Encodable[] attributeValues = instance.getAttributeValues();
        ArrayList<ASN1Encodable> remainingERs = new ArrayList<ASN1Encodable>();
        for (ASN1Encodable er : attributeValues) {
            if (this.toSkip <= 0) {
                erList.add(er.toASN1Primitive().getEncoded());
                --this.toSkip;
                continue;
            }
            remainingERs.add(er);
        }
        if (remainingERs.isEmpty()) {
            return null;
        }
        return new Attribute(new ASN1ObjectIdentifier(attributeIdentifier), (ASN1Set)new DERSet(remainingERs.toArray(new ASN1Encodable[remainingERs.size()])));
    }
}

