/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.SSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.StreamableInputData;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.validation.er.ArchiveTimestamp;
import de.governikus.csl.validation.er.ArchiveTimestampChain;
import de.governikus.csl.validation.er.ArchiveTimestampToken;
import de.governikus.csl.validation.er.EvidenceRecord;
import de.governikus.csl.validation.tsp.TSPParser;
import de.governikus.csl.validation.tsp.TimestampFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EvidenceRecordCreator {
    private AlgorithmManager algorithmManager;

    public EvidenceRecordCreator(AlgorithmManager algorithmManager) {
        this.algorithmManager = algorithmManager;
    }

    public EvidenceRecord create(byte[] data) throws ParseException {
        de.bos_bremen.ci.asn1.er.EvidenceRecord er = new de.bos_bremen.ci.asn1.er.EvidenceRecord(Run.create((Source)new BSource(data)), true);
        return this.create(er);
    }

    public EvidenceRecord create(StreamableInputData data) throws ParseException {
        de.bos_bremen.ci.asn1.er.EvidenceRecord er = new de.bos_bremen.ci.asn1.er.EvidenceRecord(Run.create((Source)new SSource(data)), true);
        return this.create(er);
    }

    public EvidenceRecord create(de.bos_bremen.ci.asn1.er.EvidenceRecord er) {
        EvidenceRecord res = new EvidenceRecord();
        INTEGER version = er.getVersion();
        if (version != null) {
            res.setVersion(version.getValue().intValue());
        }
        res.setDigestAlgorithms(er.getDigestAlgorithms());
        res.setArchiveTimeStampSequence(er.getArchiveTimeStampSequence().stream().map(this::createTimestampChain).collect(Collectors.toList()));
        return res;
    }

    private ArchiveTimestampChain createTimestampChain(de.bos_bremen.ci.asn1.er.ArchiveTimestampChain chain) {
        ArchiveTimestampChain res = new ArchiveTimestampChain();
        res.setTimestamps(chain.getTimestamps().stream().map(x -> this.createArchiveTimestamp((de.bos_bremen.ci.asn1.er.ArchiveTimestamp)x)).collect(Collectors.toList()));
        res.setRawData(chain.getEncoded());
        return res;
    }

    private ArchiveTimestamp createArchiveTimestamp(de.bos_bremen.ci.asn1.er.ArchiveTimestamp atst) {
        List reducedHashtree;
        Map attributes;
        ArchiveTimestamp res = new ArchiveTimestamp();
        AlgorithmIdentifier digestAlgorithm = atst.getDigestAlgorithm();
        if (digestAlgorithm != null) {
            res.setDigestAlgorithm(this.algorithmManager.getDigestAlgorithmByOID(digestAlgorithm.getOID().getOID()));
        }
        if ((attributes = atst.getAttributes()) != null && !attributes.isEmpty()) {
            res.setAttributes(attributes.entrySet().stream().collect(Collectors.toMap(x -> ((OBJECTIDENTIFIER)x.getKey()).getOID(), x -> (List)x.getValue())));
        }
        if ((reducedHashtree = atst.getReducedHashtree()) != null) {
            res.setReducedHashtree(reducedHashtree.stream().map(this::mapPartialTree).collect(Collectors.toList()));
        }
        res.setTimestamp(this.parseTimestamp(atst.getTimestamp()));
        return res;
    }

    private List<byte[]> mapPartialTree(List<OCTETSTRING> data) {
        return data.stream().map(OCTETSTRING::getOctets).collect(Collectors.toList());
    }

    private ArchiveTimestampToken parseTimestamp(de.bos_bremen.ci.asn1.cms.ArchiveTimestamp timestamp) {
        TSPParser parser = new TSPParser(this.algorithmManager);
        ArchiveTimestampToken res = parser.parse((SignedData)timestamp.getContent(), null, new ArchiveTimestampFactory()).get(0);
        res.setRawTimestampToken(timestamp.getEncoded());
        return res;
    }

    private class ArchiveTimestampFactory
    implements TimestampFactory<ArchiveTimestampToken, BaseSignature> {
        private ArchiveTimestampFactory() {
        }

        @Override
        public ArchiveTimestampToken createNewTimestamp() {
            return new ArchiveTimestampToken();
        }
    }
}

