/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.validate.svp.ERArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.ERHashTreeValidationResult;
import de.governikus.csl.validation.er.ArchiveTimestamp;
import de.governikus.csl.validation.er.ArchiveTimestampTokenValidationResult;
import de.governikus.csl.validation.er.ReducedHashTreeDigestAlgorithmValidator;
import de.governikus.csl.validation.er.ReducedHashTreeValidationResponse;
import de.governikus.csl.validation.er.ReducedHashTreeValidator;
import de.governikus.csl.validation.er.TimestampTokenValidator;
import java.util.Date;
import java.util.List;

public class ArchiveTimestampValidator {
    private TimestampTokenValidator timestampValidator;
    private ReducedHashTreeValidator hashTreeValidator;
    private ReducedHashTreeDigestAlgorithmValidator hashTreeDigestMethodValidator;

    public ArchiveTimestampValidator(TimestampTokenValidator timestampValidator, ReducedHashTreeValidator hashTreeValidator, ReducedHashTreeDigestAlgorithmValidator hashTreeDigestMethodValidator) {
        this.timestampValidator = timestampValidator;
        this.hashTreeValidator = hashTreeValidator;
        this.hashTreeDigestMethodValidator = hashTreeDigestMethodValidator;
    }

    public ERArchiveTimestampValidationResult validate(ArchiveTimestamp archiveTimestamp, Date validAt, byte[] ... hashes) {
        boolean hasHashTree;
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm(archiveTimestamp);
        List<List<byte[]>> reducedHashtree = archiveTimestamp.getReducedHashtree();
        boolean hashCovered = true;
        byte[] timestampedHash = hashes[0];
        boolean bl = hasHashTree = reducedHashtree != null && !reducedHashtree.isEmpty();
        if (hasHashTree) {
            ReducedHashTreeValidationResponse hashTreeResult = this.hashTreeValidator.validate(reducedHashtree, digestAlgorithm, hashes);
            hashCovered = hashTreeResult.isDataInTree();
            timestampedHash = hashTreeResult.getRootHash();
        }
        ArchiveTimestampTokenValidationResult timestampTokenValidationResult = this.timestampValidator.validateTimestampToken(archiveTimestamp.getTimestamp(), timestampedHash, validAt);
        ERArchiveTimestampValidationResult res = new ERArchiveTimestampValidationResult();
        if (hasHashTree) {
            ERHashTreeValidationResult hashTreeResult = new ERHashTreeValidationResult();
            this.hashTreeDigestMethodValidator.validateDigestAlgorithm(digestAlgorithm, timestampTokenValidationResult.getUsedPolicy(), hashTreeResult, validAt);
            hashTreeResult.setDataCovered(hashCovered);
            res.setHashTreeValidationResult(hashTreeResult);
        }
        res.setTimestampTokenValidationResult(timestampTokenValidationResult.getTokenResult());
        res.setValidationDate(validAt);
        return res;
    }

    private DigestAlgorithm getDigestAlgorithm(ArchiveTimestamp archiveTimestamp) {
        DigestAlgorithm digestAlgorithm = archiveTimestamp.getDigestAlgorithm();
        if (digestAlgorithm != null) {
            return digestAlgorithm;
        }
        return archiveTimestamp.getTimestamp().getMessageImprintHashAlgorithm();
    }
}

