/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.er;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.utils.DigestUtil;
import de.governikus.csl.validate.svp.ERArchiveTimestampChainValidationResult;
import de.governikus.csl.validate.svp.ERArchiveTimestampValidationResult;
import de.governikus.csl.validation.er.ArchiveTimestamp;
import de.governikus.csl.validation.er.ArchiveTimestampChain;
import de.governikus.csl.validation.er.ArchiveTimestampValidator;
import java.util.Date;
import java.util.List;

public class ArchiveTimestampChainValidator {
    private ArchiveTimestampValidator timestampValidator;

    public ArchiveTimestampChainValidator(ArchiveTimestampValidator timestampValidator) {
        this.timestampValidator = timestampValidator;
    }

    public ERArchiveTimestampChainValidationResult validate(ArchiveTimestampChain archiveTimestampChain, Date validAt, byte[] ... hashes) {
        List<ArchiveTimestamp> timestamps = archiveTimestampChain.getTimestamps();
        int numTimestamps = timestamps.size();
        Object hashToValidate = hashes;
        ERArchiveTimestampChainValidationResult res = new ERArchiveTimestampChainValidationResult();
        List timestampResponses = res.getTimestampResponses();
        for (int i = 0; i < numTimestamps; ++i) {
            Date validationDate = validAt;
            if (i < numTimestamps - 1) {
                validationDate = timestamps.get(i + 1).getTimestamp().getGenerationTime();
            }
            ArchiveTimestamp archiveTimestamp = timestamps.get(i);
            ERArchiveTimestampValidationResult archiveTimestampValidationResult = this.timestampValidator.validate(archiveTimestamp, validationDate, (byte[][])hashToValidate);
            timestampResponses.add(archiveTimestampValidationResult);
            hashToValidate = new byte[][]{DigestUtil.createHash((byte[])archiveTimestamp.getTimestamp().getRawTimestampToken(), (DigestAlgorithm)archiveTimestamp.getDigestAlgorithm())};
        }
        return res;
    }
}

