/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.dataExtractor;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.dataExtractor.DataExtractor;

public class DefaultSignatureDataExtractor<SIG extends Signature, RES extends SignatureValidationResult>
implements DataExtractor<SIG, RES> {
    @Override
    public void extractData(SIG source, RES destination) {
        if (source.getSignedContentParts() != null) {
            for (SignedContentPart contentPart : source.getSignedContentParts()) {
                String contentName = contentPart.getContentName();
                if (contentName == null) continue;
                destination.getContentNames().add(contentName);
            }
        }
        destination.setSignatureClass(source.getSignatureClass());
        destination.setParseError(SVPFactory.create((ValidationResult)source.getParseError()));
        destination.setSignatureAlgorithm(SVPFactory.createSignatureAlgorithm((SignatureAlgorithm)source.getSignatureAlgorithm()));
        TypedDate signingTime = source.getSigningTime();
        if (signingTime != null) {
            destination.setClaimedSigningTime(signingTime.getDate());
        }
    }
}

