/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.er.ERS;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureMathCheck
extends AbstractValidationCriterion<de.governikus.csl.uom.validate.commons.Signature, SignatureValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureMathCheck.class);

    private byte[] getDigest(InputStream dataToCheck, DigestAlgorithm algorithm) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)algorithm.getJCAName());
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int read = 0;
        try {
            while ((read = dataToCheck.read(buffer)) > 0) {
                md.update(buffer, 0, read);
            }
        }
        catch (IOException e) {
            LOGGER.info("Could not read message digest.", (Throwable)e);
        }
        return md.digest();
    }

    @Override
    public void verify(de.governikus.csl.uom.validate.commons.Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        X509CertificateImpl signingCertificate = signature.getSigningCertificate();
        if (signingCertificate == null && !(signature instanceof ERS)) {
            LOGGER.debug("Could not check signature mathematically. No signing certificate.");
            result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.NO_SIGNING_CERTIFICATE_FOUND));
            return;
        }
        if (signingCertificate != null && signature.getType() == SignedObjectType.DATA && this.isContentFileMissing(signature, result)) {
            LOGGER.debug("Could not check {} signature mathematically from {}. Missing detached content.", (Object)signature.getType(), (Object)signingCertificate.getSubjectX500Principal());
            result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.SIGNED_DATA_NOT_FOUND, (String[])new String[]{"detached_content_file_missing"}));
            return;
        }
        if (signingCertificate != null) {
            LOGGER.debug("Verifying {} signature mathematically created by {}", (Object)signature.getType(), (Object)signingCertificate.getSubjectX500Principal());
        } else if (signature instanceof ERS) {
            LOGGER.info("Verifying {} {} mathematically for ers contents {}", new Object[]{signature.getClass().getSimpleName(), signature.getType(), ((ERS)signature).getContentNames()});
        }
        List sParts = signature.getSignedContentParts();
        if (sParts != null) {
            for (SignedContentPart scp : sParts) {
                DigestAlgorithm algorithm = scp.getDigestAlgorithm();
                if (algorithm == null) {
                    LOGGER.debug("Could not check signature mathematically. No signature hash algorithm.");
                    result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_hash_algorithm_missing"}));
                    return;
                }
                try {
                    byte[] sigDigest;
                    boolean b;
                    byte[] digest = scp.getCalculatedDigest();
                    if (digest == null) {
                        try (InputStream contentIn = scp.getContentPart();){
                            digest = this.getDigest(contentIn, algorithm);
                        }
                        scp.setCalculatedDigest(digest);
                    }
                    if (b = MessageDigest.isEqual(digest, sigDigest = scp.getDigest())) continue;
                    result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.HASH_FAILURE));
                    return;
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    LOGGER.debug("Could not check signature mathematically. Unsupported algorithm.", (Throwable)e);
                    result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_hash_algorithm_missing"}));
                    return;
                }
                catch (IOException e1) {
                    LOGGER.info("Can't open stream to signed content", (Throwable)e1);
                    result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.SIGNED_DATA_NOT_FOUND));
                    return;
                }
            }
        } else if (signature instanceof ERS) {
            if (((ERS)signature).isContainedInAsicE()) {
                result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.SIGNED_DATA_NOT_FOUND));
            } else {
                result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null));
            }
            return;
        }
        if (signature instanceof ERS) {
            result.setSignatureMathCheck(SVPFactory.createResultOk());
            return;
        }
        Document content = signature.getSignedContent();
        if (content != null) {
            SignatureAlgorithm algorithm = signature.getSignatureAlgorithm();
            if (algorithm == null) {
                LOGGER.debug("Could not check signature mathematically. No signature hash algorithm.");
                result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_algorithm_missing"}));
                return;
            }
            try {
                Signature sig = CryptoProviderUtil.getSignatureInstance((String)algorithm.getJCAName());
                sig.initVerify(signingCertificate.getPublicKey());
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize];
                int read = 0;
                try (InputStream is = content.getInputStream();){
                    while ((read = is.read(buffer)) > 0) {
                        sig.update(buffer, 0, read);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Could not read signature value.", (Throwable)e);
                }
                byte[] sigValue = signature.getSignatureValue();
                boolean vResult = sig.verify(sigValue);
                if (!vResult) {
                    LOGGER.debug("Mathematical verification of the signature failed.");
                    result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.SIG_CRYPTO_FAILURE));
                    return;
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
                LOGGER.debug("Could not check signature mathematically", (Throwable)e);
                result.setSignatureMathCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.CRYPTO_CONSTRAINTS_FAILURE, (String[])new String[]{"signature_algorithm_not_implemented"}));
                return;
            }
        }
        result.setSignatureMathCheck(SVPFactory.createResultOk());
    }

    public static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isContentFileMissing(de.governikus.csl.uom.validate.commons.Signature signature, SignatureValidationResult result) {
        List parts = signature.getSignedContentParts();
        if (parts == null) return false;
        Iterator iterator = parts.iterator();
        while (iterator.hasNext()) {
            SignedContentPart scp = (SignedContentPart)iterator.next();
            try {
                InputStream content = scp.getContentPart();
                Throwable throwable = null;
                try {
                    if (content != null || scp.getCalculatedDigest() != null) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (content == null) continue;
                    if (throwable != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    content.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

