/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.AlgorithmValidityResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractSignatureAlgorithmValidityCheck;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.Date;

public class SignatureAlgorithmValidityCheckAtClaimedSigningTime
extends AbstractSignatureAlgorithmValidityCheck {
    @Override
    protected Usage getUsage(SignedObjectType type, TypedDate bestSigningTime) {
        switch (type) {
            case DATA: {
                return Usage.SIGN_DATA;
            }
            case TIMESTAMP: {
                return Usage.SIGN_TIMESTAMP;
            }
            case CERTIFICATE: 
            case ATTRIBUTE_CERTIFICATE: {
                return Usage.SIGN_CERTIFICATE;
            }
            case OCSP: 
            case CRL: {
                return Usage.SIGN_OCSP;
            }
        }
        return null;
    }

    @Override
    protected TypedDate getValidationTime(Signature signature, SignatureValidationContext context) {
        return signature.getSigningTime();
    }

    @Override
    protected boolean isOldAlgorithmCausingInvalidResult(ValidatePolicy policy, Signature signature, Date expirationDate, TypedDate timeToCheckAt) {
        return true;
    }

    @Override
    protected void setSignatureAlgorithmValidationResult(SignatureValidationResult result, AlgorithmValidityResult signatureAlgorithmValidationResult) {
        result.setSignatureAlgorithmValidityAtClaimedSigningTime(signatureAlgorithmValidationResult);
    }

    @Override
    public boolean isApplicable(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        ValidationPolicyType policy = context.getPolicy();
        boolean applicable = policy.isAlgorithmValidityCheckAtClaimedSigningTimeRequired();
        if (!applicable) {
            this.buildInvalidateResult(result);
        }
        return applicable;
    }

    @Override
    protected void setExpirationDate(SignatureValidationResult validationResult, Date signatureAlgorithmExpirationDate, boolean withoutExpirationDate) {
        validationResult.setSignatureAlgorithmExpirationDateSign(signatureAlgorithmExpirationDate);
    }
}

