/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.AlgorithmValidityResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractSignatureAlgorithmValidityCheck;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureAlgorithmValidityCheckAtBestPOE
extends AbstractSignatureAlgorithmValidityCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureAlgorithmValidityCheckAtBestPOE.class);

    @Override
    protected void setSignatureAlgorithmValidationResult(SignatureValidationResult result, AlgorithmValidityResult signatureAlgorithmValidationResult) {
        result.setSignatureAlgorithmValidityAtBestPOE(signatureAlgorithmValidationResult);
    }

    @Override
    public boolean isApplicable(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        ValidationPolicyType policy = context.getPolicy();
        boolean applicable = policy.isAlgorithmValidityCheckAtBestPOERequired();
        if (!applicable) {
            this.buildInvalidateResult(result);
        }
        return applicable;
    }

    @Override
    protected boolean isOldAlgorithmCausingInvalidResult(ValidatePolicy policy, Signature signature, Date expirationDate, TypedDate timeToCheckAt) {
        return policy.isInvalidateOldAlgorithms();
    }

    @Override
    protected TypedDate getValidationTime(Signature signature, SignatureValidationContext context) {
        return context.getBestAlgValidationTime();
    }

    @Override
    protected Usage getUsage(SignedObjectType type, TypedDate bestSigningTime) {
        switch (type) {
            case DATA: {
                return Usage.VERIFY_DATA_SIGNATURE;
            }
            case TIMESTAMP: {
                return Usage.VERIFY_TIMESTAMP_SIGNATURE;
            }
            case CERTIFICATE: 
            case ATTRIBUTE_CERTIFICATE: {
                return Usage.VERIFY_CERTIFICATE_SIGNATURE;
            }
            case OCSP: 
            case CRL: {
                return Usage.VERIFY_OCSP_SIGNATURE;
            }
        }
        return null;
    }

    @Override
    protected void setExpirationDate(SignatureValidationResult validationResult, Date signatureAlgorithmExpirationDate, boolean withoutExpirationDate) {
        validationResult.setSignatureAlgorithmExpirationDateVal(signatureAlgorithmExpirationDate);
    }
}

