/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.CheckAttributeCertificates;
import de.governikus.csl.validation.criteria.CheckClaimedSigningTime;
import de.governikus.csl.validation.criteria.CheckSigningCertificate;
import de.governikus.csl.validation.criteria.CheckSigningCertificateUsage;
import de.governikus.csl.validation.criteria.SignatureAlgorithmValidityCheckAtBestPOE;
import de.governikus.csl.validation.criteria.SignatureAlgorithmValidityCheckAtClaimedSigningTime;
import de.governikus.csl.validation.criteria.SignatureAlgorithmValidityCheckAtValidationDate;
import de.governikus.csl.validation.criteria.SignatureMathCheck;
import java.util.ArrayList;
import java.util.List;

public class CriteriaFactory {
    public static List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> getAllBasicCritieria() {
        return CriteriaFactory.getAllBasicCritieria(true);
    }

    public static List<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> getAllBasicCritieria(boolean returnLocalCertificateValidation) {
        ArrayList<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>> signatureCriterias = new ArrayList<ValidationCriterion<? super Signature, ? super SignatureValidationResult, ? super SignatureValidationContext>>();
        signatureCriterias.add(new SignatureMathCheck());
        signatureCriterias.add(new SignatureAlgorithmValidityCheckAtBestPOE());
        signatureCriterias.add(new CheckSigningCertificateUsage());
        signatureCriterias.add(new CheckClaimedSigningTime());
        signatureCriterias.add(new SignatureAlgorithmValidityCheckAtValidationDate());
        signatureCriterias.add(new SignatureAlgorithmValidityCheckAtClaimedSigningTime());
        if (returnLocalCertificateValidation) {
            signatureCriterias.add(new CheckSigningCertificate());
            signatureCriterias.add(new CheckAttributeCertificates());
        }
        return signatureCriterias;
    }
}

