/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.criteria;

import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.KeyUsage;
import de.governikus.csl.uom.validate.KeyUsageCheckSettings;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.revocation.RevocationValueData;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSigningCertificateUsage
extends AbstractValidationCriterion<Signature, SignatureValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckSigningCertificateUsage.class);

    @Override
    public void verify(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        X509CertificateImpl signingCertificate = signature.getSigningCertificate();
        if (signingCertificate == null) {
            LOGGER.debug("Verifying usage of signing certificate skipped due to missing signing certificate");
            return;
        }
        LOGGER.debug("Verifying usage of signing certificate: {}", (Object)signingCertificate.getSubjectX500Principal());
        SignedObjectType type = signature.getType();
        ValidationResult validationResult = SVPFactory.createResultOk();
        ValidationResult checkKeyUsage = this.checkKeyUsage(signingCertificate, type);
        ValidationResult checkExtendedKeyUsage = this.checkExtendedKeyUsage(signature);
        validationResult.setMajor(MajorTotalResult.max((MajorTotalResult)checkKeyUsage.getMajor(), (MajorTotalResult)checkExtendedKeyUsage.getMajor()));
        validationResult.getMessages().addAll(checkKeyUsage.getMessages());
        validationResult.getMessages().addAll(checkExtendedKeyUsage.getMessages());
        result.setSigningCertificateUsageCheck(validationResult);
    }

    private ValidationResult checkExtendedKeyUsage(Signature signature) {
        ValidationResult validationResult = SVPFactory.createResultOk();
        if (signature.getType() == SignedObjectType.OCSP) {
            RevocationValueData revocationValueData = (RevocationValueData)signature;
            LOGGER.debug("Verifying usage of OCSP response signing certificate {}", (Object)revocationValueData.getSigningCertificate().getSubjectX500Principal().getName());
            Optional.of(revocationValueData).filter(CheckSigningCertificateUsage.not(this::isDirectlyIssuedOrDelegated)).ifPresent(x -> this.setMissingExtendedKeyUsageResult(validationResult));
        }
        return validationResult;
    }

    private void setMissingExtendedKeyUsageResult(ValidationResult validationResult) {
        ValidationMessageCode code = SVPFactory.createMessageCode((String)"revocation_values_signer_certificate_ext_key_usage");
        validationResult.getMessages().add(code);
        validationResult.setMajor(MajorTotalResult.INDETERMINATE);
    }

    private ValidationResult checkKeyUsage(X509CertificateImpl signingCertificate, SignedObjectType type) {
        ArrayList<KeyUsage> usages = new ArrayList<KeyUsage>();
        switch (type) {
            case CERTIFICATE: 
            case ATTRIBUTE_CERTIFICATE: {
                usages.add(KeyUsage.KEY_CERT_SIGN);
                break;
            }
            case OCSP: {
                usages.add(KeyUsage.NON_REPUDIATION);
                usages.add(KeyUsage.DIGITAL_SIGNATURE);
                break;
            }
            case CRL: {
                usages.add(KeyUsage.CRL_SIGN);
                break;
            }
            case TIMESTAMP: {
                return SVPFactory.createResultOk();
            }
            case DATA: {
                usages.add(KeyUsage.DIGITAL_SIGNATURE);
                usages.add(KeyUsage.NON_REPUDIATION);
                break;
            }
            default: {
                LOGGER.warn("Unsupported signed object type!");
            }
        }
        if (usages.stream().anyMatch(arg_0 -> ((X509CertificateImpl)signingCertificate).isUsableFor(arg_0))) {
            return SVPFactory.createResultOk();
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (String[])new String[]{"x509_key_usage"});
    }

    private boolean isDirectlyIssuedOrDelegated(RevocationValueData revocationValueData) {
        return this.isIssuedBySameCA(revocationValueData) || this.hasOCSPSigningExtendedKeyUsage(revocationValueData);
    }

    private boolean hasOCSPSigningExtendedKeyUsage(RevocationValueData revocationValueData) {
        try {
            Predicate<String> isExtendedKeyUsage = KeyPurposeId.anyExtendedKeyUsage.getId()::equals;
            Predicate<String> isOcspSigning = KeyPurposeId.id_kp_OCSPSigning.getId()::equals;
            boolean hasAnyExtendedOrOcspSigning = Optional.ofNullable(revocationValueData.getSigningCertificate().getExtendedKeyUsage()).orElseGet(Collections::emptyList).stream().anyMatch(isExtendedKeyUsage.or(isOcspSigning));
            if (hasAnyExtendedOrOcspSigning) {
                LOGGER.debug("OCSP response signing is delegated to certificate {}", Optional.of(revocationValueData).map(BaseSignature::getSigningCertificate).map(X509CertificateImpl::getSubjectX500Principal).map(X500Principal::getName));
            }
            return hasAnyExtendedOrOcspSigning;
        }
        catch (CertificateParsingException e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
    }

    private boolean isIssuedBySameCA(RevocationValueData revocationValueData) {
        X500Principal service = Optional.ofNullable(revocationValueData).map(RevocationValueData::getValue).map(RevocationValue::getCertificateToCheck).map(CertificateBase::getIssuerX500Principal).orElse(null);
        X500Principal signer = Optional.ofNullable(revocationValueData).map(BaseSignature::getSigningCertificate).map(X509CertificateImpl::getSubjectX500Principal).orElse(null);
        if (Objects.nonNull(service) && Objects.nonNull(signer) && signer.equals(service)) {
            LOGGER.debug("OCSP response is signed by CA certificate {}", (Object)service.getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean isApplicable(Signature signature, SignatureValidationResult result, SignatureValidationContext context) {
        boolean applicable = false;
        ValidationPolicyType policy = context.getPolicy();
        KeyUsageCheckSettings keyUsageCheckSettings = policy.getKeyUsageCheckSettings();
        SignedObjectType type = signature.getType();
        switch (type) {
            case CERTIFICATE: 
            case ATTRIBUTE_CERTIFICATE: {
                applicable = keyUsageCheckSettings.isCheckCACertificateUsage();
                break;
            }
            case OCSP: 
            case CRL: {
                applicable = keyUsageCheckSettings.isCheckRevocationValueCertificateUsage();
                break;
            }
            case TIMESTAMP: {
                applicable = keyUsageCheckSettings.isCheckTSPCertificateUsage();
                break;
            }
            case DATA: {
                applicable = keyUsageCheckSettings.isCheckEndEntityCertificateUsage();
                break;
            }
            default: {
                LOGGER.warn("Unsupported signed object type!");
            }
        }
        if (!applicable) {
            result.setSigningCertificateUsageCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
        }
        return applicable;
    }

    private static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }
}

